/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.AccessType;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.AccessTypeInformation;
import org.hibernate.jpamodelgen.model.MetaEntity;

public final class Context {
    private static final String DEFAULT_PERSISTENCE_XML_LOCATION = "/META-INF/persistence.xml";
    private final Map<String, MetaEntity> metaEntities = new HashMap<String, MetaEntity>();
    private final Map<String, MetaEntity> metaEmbeddables = new HashMap<String, MetaEntity>();
    private final Map<String, AccessTypeInformation> accessTypeInformation = new HashMap<String, AccessTypeInformation>();
    private final ProcessingEnvironment pe;
    private final boolean logDebug;
    private final boolean lazyXmlParsing;
    private final String persistenceXmlLocation;
    private final List<String> ormXmlFiles;
    private boolean isPersistenceUnitCompletelyXmlConfigured;
    private boolean addGeneratedAnnotation;
    private AccessType persistenceUnitDefaultAccessType;

    public Context(ProcessingEnvironment pe) {
        String tmp;
        this.pe = pe;
        if (pe.getOptions().get("persistenceXml") != null) {
            tmp = pe.getOptions().get("persistenceXml");
            if (!tmp.startsWith("/")) {
                tmp = "/" + tmp;
            }
            this.persistenceXmlLocation = tmp;
        } else {
            this.persistenceXmlLocation = DEFAULT_PERSISTENCE_XML_LOCATION;
        }
        if (pe.getOptions().get("ormXmlList") != null) {
            tmp = pe.getOptions().get("ormXmlList");
            this.ormXmlFiles = new ArrayList<String>();
            for (String ormFile : tmp.split(",")) {
                if (!ormFile.startsWith("/")) {
                    ormFile = "/" + ormFile;
                }
                this.ormXmlFiles.add(ormFile);
            }
        } else {
            this.ormXmlFiles = Collections.emptyList();
        }
        this.lazyXmlParsing = Boolean.parseBoolean(pe.getOptions().get("lazyXmlParsing"));
        this.logDebug = Boolean.parseBoolean(pe.getOptions().get("debug"));
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.pe;
    }

    public boolean isAddGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public void setAddGeneratedAnnotation(boolean addGeneratedAnnotation) {
        this.addGeneratedAnnotation = addGeneratedAnnotation;
    }

    public Elements getElementUtils() {
        return this.pe.getElementUtils();
    }

    public Types getTypeUtils() {
        return this.pe.getTypeUtils();
    }

    public String getPersistenceXmlLocation() {
        return this.persistenceXmlLocation;
    }

    public List<String> getOrmXmlFiles() {
        return this.ormXmlFiles;
    }

    public boolean containsMetaEntity(String fqcn) {
        return this.metaEntities.containsKey(fqcn);
    }

    public MetaEntity getMetaEntity(String fqcn) {
        return this.metaEntities.get(fqcn);
    }

    public Collection<MetaEntity> getMetaEntities() {
        return this.metaEntities.values();
    }

    public void addMetaEntity(String fqcn, MetaEntity metaEntity) {
        this.metaEntities.put(fqcn, metaEntity);
    }

    public boolean containsMetaEmbeddable(String fqcn) {
        return this.metaEmbeddables.containsKey(fqcn);
    }

    public MetaEntity getMetaEmbeddable(String fqcn) {
        return this.metaEmbeddables.get(fqcn);
    }

    public void addMetaEmbeddable(String fqcn, MetaEntity metaEntity) {
        this.metaEmbeddables.put(fqcn, metaEntity);
    }

    public Collection<MetaEntity> getMetaEmbeddables() {
        return this.metaEmbeddables.values();
    }

    public void addAccessTypeInformation(String fqcn, AccessTypeInformation info) {
        this.accessTypeInformation.put(fqcn, info);
    }

    public AccessTypeInformation getAccessTypeInfo(String fqcn) {
        return this.accessTypeInformation.get(fqcn);
    }

    public TypeElement getTypeElementForFullyQualifiedName(String fqcn) {
        Elements elementUtils = this.pe.getElementUtils();
        return elementUtils.getTypeElement(fqcn);
    }

    public void logMessage(Diagnostic.Kind type, String message) {
        if (!this.logDebug && type.equals((Object)Diagnostic.Kind.OTHER)) {
            return;
        }
        this.pe.getMessager().printMessage(type, message);
    }

    public boolean isPersistenceUnitCompletelyXmlConfigured() {
        return this.isPersistenceUnitCompletelyXmlConfigured;
    }

    public void setPersistenceUnitCompletelyXmlConfigured(boolean persistenceUnitCompletelyXmlConfigured) {
        this.isPersistenceUnitCompletelyXmlConfigured = persistenceUnitCompletelyXmlConfigured;
    }

    public AccessType getPersistenceUnitDefaultAccessType() {
        return this.persistenceUnitDefaultAccessType;
    }

    public void setPersistenceUnitDefaultAccessType(AccessType persistenceUnitDefaultAccessType) {
        this.persistenceUnitDefaultAccessType = persistenceUnitDefaultAccessType;
    }

    public boolean doLazyXmlParsing() {
        return this.lazyXmlParsing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context");
        sb.append("{accessTypeInformation=").append(this.accessTypeInformation);
        sb.append(", logDebug=").append(this.logDebug);
        sb.append(", lazyXmlParsing=").append(this.lazyXmlParsing);
        sb.append(", isPersistenceUnitCompletelyXmlConfigured=").append(this.isPersistenceUnitCompletelyXmlConfigured);
        sb.append(", ormXmlFiles=").append(this.ormXmlFiles);
        sb.append(", persistenceXmlLocation='").append(this.persistenceXmlLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

