/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;

public class CachedBundle {
    private Bundle bundle;
    private String key;
    private List<String> classNames = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resourceListNames = new ArrayList<String>();

    public CachedBundle(Bundle bundle, String key) {
        this.bundle = bundle;
        this.key = key;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        if (clazz != null) {
            this.classNames.add(name);
        }
        return clazz;
    }

    public URL getResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (resource != null) {
            this.resourceNames.add(name);
        }
        return resource;
    }

    public Enumeration getResources(String name) throws IOException {
        Enumeration resourceList = this.bundle.getResources(name);
        if (resourceList != null) {
            this.resourceListNames.add(name);
        }
        return resourceList;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public List<String> getResourceListNames() {
        return this.resourceListNames;
    }
}

