/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class HibernateBundleActivator
extends HibernatePersistence
implements BundleActivator,
BundleListener {
    private BundleContext context;
    private OsgiClassLoader osgiClassLoader;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.addBundleListener((BundleListener)this);
        this.osgiClassLoader = new OsgiClassLoader();
        ClassLoaderHelper.overridenClassLoader = this.osgiClassLoader;
        for (Bundle bundle : context.getBundles()) {
            this.handleBundleChange(bundle);
        }
        Properties properties = new Properties();
        properties.put("javax.persistence.provider", HibernateBundleActivator.class.getName());
        context.registerService(PersistenceProvider.class.getName(), (Object)this, (Dictionary)properties);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        this.handleBundleChange(event.getBundle());
    }

    private void handleBundleChange(Bundle bundle) {
        if (bundle.getState() == 32) {
            this.osgiClassLoader.registerBundle(bundle);
        } else {
            this.osgiClassLoader.unregisterBundle(bundle);
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        Ejb3Configuration configured;
        Ejb3Configuration cfg = new Ejb3Configuration();
        if (info.getTransactionType().equals((Object)PersistenceUnitTransactionType.JTA)) {
            map.put("hibernate.transaction.jta.platform", new OsgiJtaPlatform(this.context));
        }
        return (configured = cfg.configure(info, map)) != null ? configured.buildEntityManagerFactory() : null;
    }
}

