/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.service.BootstrapServiceRegistryBuilder;
import org.osgi.framework.Bundle;

public class OsgiPersistenceProvider
extends HibernatePersistence {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private Bundle requestingBundle;

    public OsgiPersistenceProvider(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, Bundle requestingBundle) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.requestingBundle = requestingBundle;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, OsgiJtaPlatform>();
        }
        properties.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        this.osgiClassLoader.addBundle(this.requestingBundle);
        Ejb3Configuration cfg = new Ejb3Configuration();
        Ejb3Configuration configured = cfg.configure(persistenceUnitName, properties);
        return configured != null ? configured.buildEntityManagerFactory(this.getBuilder(properties)) : null;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, OsgiJtaPlatform>();
        }
        properties.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        this.osgiClassLoader.addClassLoader(info.getClassLoader());
        Ejb3Configuration cfg = new Ejb3Configuration();
        Ejb3Configuration configured = cfg.configure(info, properties);
        return configured != null ? configured.buildEntityManagerFactory(this.getBuilder(properties)) : null;
    }

    private BootstrapServiceRegistryBuilder getBuilder(Map properties) {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        Collection classLoaders = (Collection)properties.get("hibernate.classLoaders");
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                this.osgiClassLoader.addClassLoader(classLoader);
            }
        }
        builder.with((ClassLoader)this.osgiClassLoader);
        return builder;
    }
}

