/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.service.BootstrapServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OsgiSessionFactoryService
implements ServiceFactory {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;

    public OsgiSessionFactoryService(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
    }

    public Object getService(Bundle requestingBundle, ServiceRegistration registration) {
        this.osgiClassLoader.addBundle(requestingBundle);
        Configuration configuration = new Configuration();
        configuration.getProperties().put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        configuration.configure();
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        builder.with((ClassLoader)this.osgiClassLoader);
        ServiceRegistry serviceRegistry = new ServiceRegistryBuilder(builder.build()).applySettings((Map)configuration.getProperties()).buildServiceRegistry();
        return configuration.buildSessionFactory(serviceRegistry);
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration registration, Object service) {
        ((SessionFactory)service).close();
    }
}

