/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiScanner;
import org.hibernate.osgi.OsgiServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class OsgiPersistenceProvider
extends HibernatePersistenceProvider {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private Bundle requestingBundle;
    private BundleContext context;

    public OsgiPersistenceProvider(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, Bundle requestingBundle, BundleContext context) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.requestingBundle = requestingBundle;
        this.context = context;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        Map settings = this.generateSettings(properties);
        settings.put("hibernate.ejb.resource_scanner", new OsgiScanner(this.requestingBundle));
        settings.put("hibernate.classLoader.environment", this.osgiClassLoader);
        this.osgiClassLoader.addBundle(this.requestingBundle);
        return super.createEntityManagerFactory(persistenceUnitName, properties);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        Map settings = this.generateSettings(properties);
        settings.put("hibernate.ejb.resource_scanner", new OsgiScanner(((BundleReference)info.getClassLoader()).getBundle()));
        this.osgiClassLoader.addClassLoader(info.getClassLoader());
        return super.createContainerEntityManagerFactory(info, properties);
    }

    private Map generateSettings(Map properties) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (properties != null) {
            settings.putAll(properties);
        }
        settings.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        final List<Integrator> integrators = OsgiServiceUtil.getServiceImpls(Integrator.class, this.context);
        IntegratorProvider integratorProvider = new IntegratorProvider(){

            public List<Integrator> getIntegrators() {
                return integrators;
            }
        };
        settings.put("hibernate.integrator_provider", integratorProvider);
        final List<StrategyRegistrationProvider> strategyRegistrationProviders = OsgiServiceUtil.getServiceImpls(StrategyRegistrationProvider.class, this.context);
        StrategyRegistrationProviderList strategyRegistrationProviderList = new StrategyRegistrationProviderList(){

            public List<StrategyRegistrationProvider> getStrategyRegistrationProviders() {
                return strategyRegistrationProviders;
            }
        };
        settings.put("hibernate.strategy_registration_provider", strategyRegistrationProviderList);
        final List<TypeContributor> typeContributors = OsgiServiceUtil.getServiceImpls(TypeContributor.class, this.context);
        TypeContributorList typeContributorList = new TypeContributorList(){

            public List<TypeContributor> getTypeContributors() {
                return typeContributors;
            }
        };
        settings.put("hibernate.type_contributors", typeContributorList);
        return settings;
    }
}

