/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiServiceUtil {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)OsgiServiceUtil.class.getName());

    public static <T> List<T> getServiceImpls(Class<T> contract, BundleContext context) {
        ArrayList<Object> serviceImpls = new ArrayList<Object>();
        try {
            Collection serviceRefs = context.getServiceReferences(contract, null);
            for (ServiceReference serviceRef : serviceRefs) {
                serviceImpls.add(context.getService(serviceRef));
            }
        }
        catch (Exception e) {
            LOG.unableToDiscoverOsgiService(contract.getName(), e);
        }
        return serviceImpls;
    }

    private OsgiServiceUtil() {
    }
}

