/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.osgi.OsgiServiceUtil;
import org.osgi.framework.BundleContext;

public class OsgiJtaPlatform
implements JtaPlatform {
    private static final long serialVersionUID = 1L;
    private BundleContext bundleContext;

    public OsgiJtaPlatform(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public TransactionManager retrieveTransactionManager() {
        try {
            TransactionManager transactionManager = OsgiServiceUtil.getServiceImpl(TransactionManager.class, this.bundleContext);
            if (transactionManager == null) {
                throw new TransactionException("Cannot retrieve the TransactionManager OSGi service!");
            }
            return transactionManager;
        }
        catch (Exception e) {
            throw new TransactionException("Cannot retrieve the TransactionManager OSGi service!", (Throwable)e);
        }
    }

    public UserTransaction retrieveUserTransaction() {
        try {
            UserTransaction userTransaction = OsgiServiceUtil.getServiceImpl(UserTransaction.class, this.bundleContext);
            if (userTransaction == null) {
                throw new TransactionException("Cannot retrieve the UserTransaction OSGi service!");
            }
            return userTransaction;
        }
        catch (Exception e) {
            throw new TransactionException("Cannot retrieve the UserTransaction OSGi service!", (Throwable)e);
        }
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public boolean canRegisterSynchronization() {
        try {
            return JtaStatusHelper.isActive((TransactionManager)this.retrieveTransactionManager());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.retrieveTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain transaction from OSGi services!");
        }
    }

    public int getCurrentStatus() throws SystemException {
        return this.retrieveTransactionManager().getStatus();
    }
}

