/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Collection;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.cfg.Configuration;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiServiceUtil;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiSessionFactoryService
implements ServiceFactory {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)OsgiSessionFactoryService.class.getName());
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private BundleContext context;

    public OsgiSessionFactoryService(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, BundleContext context) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.context = context;
    }

    public Object getService(Bundle requestingBundle, ServiceRegistration registration) {
        TypeContributor[] typeContributors;
        StrategyRegistrationProvider[] strategyRegistrationProviders;
        Integrator[] integrators;
        this.osgiClassLoader.addBundle(requestingBundle);
        Configuration configuration = new Configuration();
        configuration.getProperties().put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        BundleWiring bundleWiring = (BundleWiring)requestingBundle.adapt(BundleWiring.class);
        Collection cfgResources = bundleWiring.listResources("/", "hibernate.cfg.xml", 1);
        if (cfgResources.size() == 0) {
            configuration.configure();
        } else {
            if (cfgResources.size() > 1) {
                LOG.warn((Object)"Multiple hibernate.cfg.xml files found in the persistence bundle.  Using the first one discovered.");
            }
            String cfgResource = "/" + (String)cfgResources.iterator().next();
            configuration.configure(cfgResource);
        }
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        builder.with((ClassLoader)this.osgiClassLoader);
        for (Integrator integrator : integrators = OsgiServiceUtil.getServiceImpls(Integrator.class, this.context)) {
            builder.with(integrator);
        }
        for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviders = OsgiServiceUtil.getServiceImpls(StrategyRegistrationProvider.class, this.context)) {
            builder.withStrategySelectors(strategyRegistrationProvider);
        }
        for (TypeContributor typeContributor : typeContributors = OsgiServiceUtil.getServiceImpls(TypeContributor.class, this.context)) {
            configuration.registerTypeContributor(typeContributor);
        }
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder(builder.build()).applySettings((Map)configuration.getProperties()).build();
        return configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration registration, Object service) {
        ((SessionFactory)service).close();
    }
}

