/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.jgroups.common.StaticMasterSlaveSearchTestCase;
import org.hibernate.search.test.jgroups.master.TShirt;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.junit.Assert;
import org.junit.Test;

public class JGroupsCommonTest
extends StaticMasterSlaveSearchTestCase {
    public static final String TESTING_JGROUPS_CONFIGURATION_FILE = "testing-flush-loopback.xml";
    public static final Poller POLLER = Poller.milliseconds((long)10000L, (long)100L);
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();

    @Test
    public void testJGroupsBackend() throws Exception {
        FullTextSession masterSession;
        TShirt ts2;
        TShirt ts;
        Transaction tx;
        QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
        try (Session slaveSession = this.getSlaveSession();){
            tx = slaveSession.beginTransaction();
            ts = new TShirt();
            ts.setLogo("Boston");
            ts.setSize("XXL");
            ts.setLength(23.4);
            ts2 = new TShirt();
            ts2.setLogo("Mapple leaves");
            ts2.setSize("L");
            ts2.setLength(23.42);
            slaveSession.persist((Object)ts);
            slaveSession.persist((Object)ts2);
            tx.commit();
            masterSession = Search.getFullTextSession((Session)this.openSession());
            POLLER.pollAssertion(() -> {
                masterSession.getTransaction().begin();
                Query luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
                FullTextQuery query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
                List result = query.list();
                masterSession.getTransaction().commit();
                Assert.assertEquals((String)"Lots of time waited and still the two documents are not indexed yet!", (long)2L, (long)result.size());
            });
        }
        slaveSession = this.getSlaveSession();
        var6_3 = null;
        try {
            tx = slaveSession.beginTransaction();
            ts = (TShirt)slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
            ts.setLogo("Peter pan");
            tx.commit();
            POLLER.pollAssertion(() -> {
                Query luceneQuery = parser.parse("logo:Peter pan");
                masterSession.getTransaction().begin();
                FullTextQuery query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
                List result = query.list();
                masterSession.getTransaction().commit();
                Assert.assertEquals((String)"Waited for long and still Peter Pan didn't fly in!", (long)1L, (long)result.size());
            });
        }
        catch (Throwable tx2) {
            var6_3 = tx2;
            throw tx2;
        }
        finally {
            if (slaveSession != null) {
                if (var6_3 != null) {
                    try {
                        slaveSession.close();
                    }
                    catch (Throwable tx2) {
                        var6_3.addSuppressed(tx2);
                    }
                } else {
                    slaveSession.close();
                }
            }
        }
        slaveSession = this.getSlaveSession();
        var6_3 = null;
        try {
            tx = slaveSession.beginTransaction();
            slaveSession.delete(slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
            slaveSession.delete(slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts2.getId())));
            tx.commit();
            POLLER.pollAssertion(() -> {
                Query luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
                masterSession.getTransaction().begin();
                FullTextQuery query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
                List result = query.list();
                masterSession.getTransaction().commit();
                Assert.assertEquals((String)"Waited for long and elements where still not deleted!", (long)0L, (long)result.size());
            });
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (slaveSession != null) {
                if (var6_3 != null) {
                    try {
                        slaveSession.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    slaveSession.close();
                }
            }
        }
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        this.applyCommonJGroupsChannelConfiguration(cfg);
    }

    @Override
    protected void configureSlave(Map<String, Object> cfg) {
        super.configureSlave(cfg);
        this.applyCommonJGroupsChannelConfiguration(cfg);
    }

    protected void applyCommonJGroupsChannelConfiguration(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.hibernate.search.services.jgroups.clusterName", CHANNEL_NAME);
        cfg.put("hibernate.search.services.jgroups.configurationFile", TESTING_JGROUPS_CONFIGURATION_FILE);
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

