/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.View;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String jgroupsSuspectingPeer = "HSEARCH200001: Remote JGroups peer '%1$s' is suspected to have left '";
    private static final String jgroupsRemoteException = "HSEARCH200003: Exception reported from remote JGroups node '%1$s' : '%2$s'";
    private static final String unableToSendWorkViaJGroups = "HSEARCH200004: Unable to send Lucene update work via JGroups cluster";
    private static final String receivedEmptyLuceneWorksInMessage = "HSEARCH200005: Received null or empty Lucene works list in message.";
    private static final String jGroupsReceivedNewClusterView = "HSEARCH200006: Received new cluster view: %1$s";
    private static final String missingJGroupsMuxId = "HSEARCH200007: Configured JGroups channel is a Muxer! MuxId option is required: define '%s'.";
    private static final String jGroupsStartingChannelProvider = "HSEARCH200008: Starting JGroups ChannelProvider";
    private static final String jGroupsMuxIdAlreadyTaken = "HSEARCH200009: MuxId '%1$d' configured on the JGroups was already taken. Can't register handler!";
    private static final String jGroupsFlushNotPresentInStack = "HSEARCH200010: FLUSH is not present in your JGroups stack! FLUSH is needed to ensure messages are not dropped while new nodes join the cluster. Will proceed, but inconsistencies may arise!";
    private static final String jgroupsFullConfiguration = "HSEARCH200011: Using JGroups channel having configuration '%1$s'";
    private static final String jGroupsClosingChannelError = "HSEARCH200012: Problem closing channel; setting it to null";
    private static final String jGroupsChannelInjectionError = "HSEARCH200013: Object injected for JGroups channel in %1$s is of an unexpected type %2$s (expecting org.jgroups.JChannel)";
    private static final String startingJGroupsChannel = "HSEARCH200014: Starting JGroups channel using configuration '%1$s'";
    private static final String jGroupsChannelCreationUsingFileError = "HSEARCH200015: Error while trying to create a channel using config file: %1$s";
    private static final String jGroupsConfigurationNotFoundInProperties = "HSEARCH200016: Unable to use any JGroups configuration mechanisms provided in properties %1$s. Using default JGroups configuration file!";
    private static final String jGroupsDisconnectingAndClosingChannel = "HSEARCH200017: Disconnecting and closing JGroups Channel to cluster '%1$s'";
    private static final String jGroupsDefaultConfigurationFileNotFound = "HSEARCH200018: Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!";
    private static final String unableToStartJGroupsChannel = "HSEARCH200019: Unable to start JGroups channel";
    private static final String jGroupsConnectedToCluster = "HSEARCH200020: Connected to cluster [ %1$s ]. The local Address is %2$s";
    private static final String unableConnectingToJGroupsCluster = "HSEARCH200021: Unable to connect to: [%1$s] JGroups channel";
    private static final String jgroupsBlockWaitingForAck = "HSEARCH200022: JGroups backend configured for index '%1$s' using block_for_ack '%2$s'";
    private static final String legacyJGroupsConfigurationDefined = "HSEARCH200023: JGroups channel configuration should be specified in the global section [hibernate.search.services.jgroups.], not as an IndexManager property for index '%1$s'. See http://docs.jboss.org/hibernate/search/5.0/reference/en-US/html_single/#jgroups-backend";
    private static final String muxIdPropertyIsIgnored = "HSEARCH200024: The configuration property 'hibernate.search.services.jgroups.mux_id' is now ignored: JGroups 4 no longer supports Mux Channels. Use the FORK protocol instead.";
    private static final String acceptingNewClusterView = "HSEARCH200025: JGroups election: accepting new cluster view [%s]. Master is now %s for index '%s'";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void jgroupsSuspectingPeer(Address sender) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jgroupsSuspectingPeer$str(), (Object)sender);
    }

    protected String jgroupsSuspectingPeer$str() {
        return jgroupsSuspectingPeer;
    }

    protected String jgroupsRemoteException$str() {
        return jgroupsRemoteException;
    }

    @Override
    public final SearchException jgroupsRemoteException(Address sender, Throwable exception, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jgroupsRemoteException$str(), sender, exception), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendWorkViaJGroups$str() {
        return unableToSendWorkViaJGroups;
    }

    @Override
    public final SearchException unableToSendWorkViaJGroups(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSendWorkViaJGroups$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void receivedEmptyLuceneWorksInMessage() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedEmptyLuceneWorksInMessage$str(), new Object[0]);
    }

    protected String receivedEmptyLuceneWorksInMessage$str() {
        return receivedEmptyLuceneWorksInMessage;
    }

    @Override
    public final void jGroupsReceivedNewClusterView(Object view) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jGroupsReceivedNewClusterView$str(), view);
    }

    protected String jGroupsReceivedNewClusterView$str() {
        return jGroupsReceivedNewClusterView;
    }

    protected String missingJGroupsMuxId$str() {
        return missingJGroupsMuxId;
    }

    @Override
    public final SearchException missingJGroupsMuxId(String muxId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingJGroupsMuxId$str(), muxId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jGroupsStartingChannelProvider() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.jGroupsStartingChannelProvider$str(), new Object[0]);
    }

    protected String jGroupsStartingChannelProvider$str() {
        return jGroupsStartingChannelProvider;
    }

    protected String jGroupsMuxIdAlreadyTaken$str() {
        return jGroupsMuxIdAlreadyTaken;
    }

    @Override
    public final SearchException jGroupsMuxIdAlreadyTaken(short n) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jGroupsMuxIdAlreadyTaken$str(), n));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jGroupsFlushNotPresentInStack() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jGroupsFlushNotPresentInStack$str(), new Object[0]);
    }

    protected String jGroupsFlushNotPresentInStack$str() {
        return jGroupsFlushNotPresentInStack;
    }

    @Override
    public final void jgroupsFullConfiguration(String printProtocolSpecAsXML) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.jgroupsFullConfiguration$str(), (Object)printProtocolSpecAsXML);
    }

    protected String jgroupsFullConfiguration$str() {
        return jgroupsFullConfiguration;
    }

    @Override
    public final void jGroupsClosingChannelError(Exception toLog) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)toLog, this.jGroupsClosingChannelError$str(), new Object[0]);
    }

    protected String jGroupsClosingChannelError$str() {
        return jGroupsClosingChannelError;
    }

    protected String jGroupsChannelInjectionError$str() {
        return jGroupsChannelInjectionError;
    }

    @Override
    public final SearchException jGroupsChannelInjectionError(String channelInject, Exception e, Class<?> actualType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jGroupsChannelInjectionError$str(), channelInject, new ClassFormatter(actualType)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void startingJGroupsChannel(Object cfg) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingJGroupsChannel$str(), cfg);
    }

    protected String startingJGroupsChannel$str() {
        return startingJGroupsChannel;
    }

    protected String jGroupsChannelCreationUsingFileError$str() {
        return jGroupsChannelCreationUsingFileError;
    }

    @Override
    public final SearchException jGroupsChannelCreationUsingFileError(String configuration, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jGroupsChannelCreationUsingFileError$str(), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jGroupsConfigurationNotFoundInProperties(Properties props) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jGroupsConfigurationNotFoundInProperties$str(), (Object)props);
    }

    protected String jGroupsConfigurationNotFoundInProperties$str() {
        return jGroupsConfigurationNotFoundInProperties;
    }

    @Override
    public final void jGroupsDisconnectingAndClosingChannel(String clusterName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jGroupsDisconnectingAndClosingChannel$str(), (Object)clusterName);
    }

    protected String jGroupsDisconnectingAndClosingChannel$str() {
        return jGroupsDisconnectingAndClosingChannel;
    }

    @Override
    public final void jGroupsDefaultConfigurationFileNotFound() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jGroupsDefaultConfigurationFileNotFound$str(), new Object[0]);
    }

    protected String jGroupsDefaultConfigurationFileNotFound$str() {
        return jGroupsDefaultConfigurationFileNotFound;
    }

    protected String unableToStartJGroupsChannel$str() {
        return unableToStartJGroupsChannel;
    }

    @Override
    public final SearchException unableToStartJGroupsChannel(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToStartJGroupsChannel$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jGroupsConnectedToCluster(String clusterName, Object address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jGroupsConnectedToCluster$str(), (Object)clusterName, address);
    }

    protected String jGroupsConnectedToCluster$str() {
        return jGroupsConnectedToCluster;
    }

    protected String unableConnectingToJGroupsCluster$str() {
        return unableConnectingToJGroupsCluster;
    }

    @Override
    public final SearchException unableConnectingToJGroupsCluster(String clusterName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableConnectingToJGroupsCluster$str(), clusterName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jgroupsBlockWaitingForAck(String indexName, boolean block) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.jgroupsBlockWaitingForAck$str(), (Object)indexName, (Object)block);
    }

    protected String jgroupsBlockWaitingForAck$str() {
        return jgroupsBlockWaitingForAck;
    }

    protected String legacyJGroupsConfigurationDefined$str() {
        return legacyJGroupsConfigurationDefined;
    }

    @Override
    public final SearchException legacyJGroupsConfigurationDefined(String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.legacyJGroupsConfigurationDefined$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void muxIdPropertyIsIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.muxIdPropertyIsIgnored$str(), new Object[0]);
    }

    protected String muxIdPropertyIsIgnored$str() {
        return muxIdPropertyIsIgnored;
    }

    @Override
    public final void acceptingNewClusterView(View view, Address masterAddress, String indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.acceptingNewClusterView$str(), (Object)view, (Object)masterAddress, (Object)indexName);
    }

    protected String acceptingNewClusterView$str() {
        return acceptingNewClusterView;
    }

    public final void interruptedWhileWaitingForIndexActivity(String arg0, InterruptedException arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.interruptedWhileWaitingForIndexActivity$str(), (Object)arg0);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    public final void illegalObjectRetrievedFromMessage(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    public final SearchException unableToLoadResource(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    public final AssertionFailure unknownResolution(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    public final SearchException unsupportedFacetRangeParameter(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String arg0, Class<?> arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier arg0, String arg1, Class<?> arg2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(arg0), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String arg0, Exception arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

