/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.util.List;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JGroupsReceiver
extends ReceiverAdapter {
    public static volatile int queues;
    public static volatile int works;
    private final SearchIntegrator integrator;

    public JGroupsReceiver(SearchIntegrator integrator) {
        this.integrator = integrator;
    }

    public static void reset() {
        queues = 0;
        works = 0;
    }

    public void receive(Message message) {
        try {
            byte[] rawBuffer = message.getRawBuffer();
            int messageOffset = message.getOffset();
            int bufferLength = message.getLength();
            byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue((int)messageOffset, (int)bufferLength, (byte[])rawBuffer);
            ServiceManager serviceManager = this.integrator.getServiceManager();
            LuceneWorkSerializer luceneWorkSerializer = (LuceneWorkSerializer)serviceManager.requestService(LuceneWorkSerializer.class);
            List queue = luceneWorkSerializer.toLuceneWorks(serializedQueue);
            ++queues;
            works += queue.size();
            serviceManager.releaseService(LuceneWorkSerializer.class);
        }
        catch (ClassCastException e) {
            throw new SearchException((Throwable)e);
        }
    }
}

