/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.testsupport.TestConstants;

public abstract class StaticMasterSlaveSearchTestCase
extends SearchTestBase {
    protected static final String masterCopy = "/master/copy";
    protected static final String masterMain = "/master/main";
    protected static final String slave = "/slave";
    private DefaultTestResourceManager slaveResources;

    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.put("hibernate.search.default.sourceBase", TestConstants.getIndexDirectory((Path)this.getTargetDir()) + masterCopy);
        cfg.put("hibernate.search.default.indexBase", TestConstants.getIndexDirectory((Path)this.getTargetDir()) + masterMain);
        cfg.put("hibernate.search.default.refresh", "1");
        cfg.put("hibernate.search.default.directory_provider", "filesystem-master");
    }

    protected void configureSlave(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.put("hibernate.search.default.retry_initialize_period", "1");
        cfg.put("hibernate.search.default.sourceBase", TestConstants.getIndexDirectory((Path)this.getTargetDir()) + masterCopy);
        cfg.put("hibernate.search.default.indexBase", TestConstants.getIndexDirectory((Path)this.getTargetDir()) + slave);
        cfg.put("hibernate.search.default.refresh", "1");
        cfg.put("hibernate.search.default.directory_provider", "filesystem-slave");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.buildSlaveSessionFactory();
    }

    public void tearDown() throws Exception {
        if (this.slaveResources != null) {
            this.slaveResources.closeSessionFactory();
            this.slaveResources = null;
        }
        super.tearDown();
    }

    private void buildSlaveSessionFactory() throws Exception {
        if (this.slaveResources != null) {
            throw new IllegalStateException("Slave SessionFactory already created");
        }
        HashMap<String, Object> slaveConfiguration = new HashMap<String, Object>();
        this.configureSlave(slaveConfiguration);
        ImmutableTestConfiguration slaveTestConfiguration = new ImmutableTestConfiguration(slaveConfiguration, this.getAnnotatedClasses());
        this.slaveResources = new DefaultTestResourceManager((TestConfiguration)slaveTestConfiguration, ((Object)((Object)this)).getClass());
        this.slaveResources.openSessionFactory();
    }

    protected Session getSlaveSession() {
        return this.slaveResources.openSession();
    }

    protected SessionFactory getSlaveSessionFactory() {
        return this.slaveResources.getSessionFactory();
    }

    private Path getTargetDir() {
        URI classesDirUri;
        try {
            classesDirUri = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Paths.get(classesDirUri).getParent();
    }
}

