/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.master;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.test.jgroups.master.TShirt;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JGroupsMasterTest
extends SearchTestBase {
    private static final Poller POLLER = JGroupsCommonTest.POLLER;
    private static final IndexedTypeIdentifier tshirtType = new PojoIndexedTypeIdentifier(TShirt.class);
    private final QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();
    private JChannel channel;

    @Test
    public void testMessageSending() throws Exception {
        TShirt shirt = this.createObject();
        List<LuceneWork> queue = this.createDocumentAndWorkQueue(shirt);
        Assert.assertEquals((long)0L, (long)this.countByQuery("logo:jboss"));
        this.sendMessage(queue);
        POLLER.pollAssertion(() -> Assert.assertEquals((String)"Message not received after waiting for long!", (long)1L, (long)this.countByQuery("logo:jboss")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByQuery(String luceneQueryString) throws ParseException {
        try (FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());){
            int n;
            ftSess.getTransaction().begin();
            try {
                Query luceneQuery = this.parser.parse(luceneQueryString);
                FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
                List result = query.list();
                n = result.size();
            }
            catch (Throwable throwable) {
                ftSess.getTransaction().commit();
                throw throwable;
            }
            ftSess.getTransaction().commit();
            return n;
        }
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        this.channel.connect(CHANNEL_NAME);
    }

    private void sendMessage(List<LuceneWork> queue) throws Exception {
        String indexManagerName = this.getIndexName();
        ServiceManager serviceManager = this.getExtendedSearchIntegrator().getServiceManager();
        byte[] data = ((LuceneWorkSerializer)serviceManager.requestService(LuceneWorkSerializer.class)).toSerializedModel(queue);
        data = MessageSerializationHelper.prependString((String)indexManagerName, (byte[])data);
        Message message = new Message(null, null, data);
        this.channel.send(message);
        serviceManager.releaseService(LuceneWorkSerializer.class);
    }

    protected String getIndexName() {
        return tshirtType.getName();
    }

    private List<LuceneWork> createDocumentAndWorkQueue(TShirt shirt) {
        Document doc = new Document();
        Field field = new Field("_hibernate_class", shirt.getClass().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((IndexableField)field);
        field = new Field("id", String.valueOf(shirt.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((IndexableField)field);
        field = new Field("logo", shirt.getLogo(), Field.Store.NO, Field.Index.ANALYZED);
        doc.add((IndexableField)field);
        DoubleField numField = new DoubleField("length", shirt.getLength(), Field.Store.NO);
        doc.add((IndexableField)numField);
        AddLuceneWork luceneWork = new AddLuceneWork((Serializable)Integer.valueOf(shirt.getId()), String.valueOf(shirt.getId()), tshirtType, doc);
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>();
        queue.add((LuceneWork)luceneWork);
        return queue;
    }

    private TShirt createObject() {
        Session s = this.openSession();
        s.getTransaction().begin();
        TShirt ts = new TShirt();
        ts.setLogo("JBoss balls");
        ts.setSize("large");
        ts.setLength(23.2);
        s.persist((Object)ts);
        s.getTransaction().commit();
        s.close();
        return ts;
    }

    @Before
    public void setUp() throws Exception {
        this.prepareJGroupsChannel();
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.indexing_strategy", IndexingMode.MANUAL.toExternalRepresentation());
        cfg.put("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.put("hibernate.search.services.jgroups.clusterName", CHANNEL_NAME);
        cfg.put("hibernate.search.services.jgroups.configurationFile", "testing-flush-loopback.xml");
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

