/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jms.impl;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.backend.jms.impl.JmsBackendQueueProcessor;
import org.hibernate.search.util.impl.JNDIHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JndiJMSBackendQueueProcessor
extends JmsBackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    private String jmsConnectionFactoryName;

    @Override
    protected QueueConnectionFactory initializeJMSQueueConnectionFactory(Properties properties) {
        this.jmsConnectionFactoryName = properties.getProperty("worker.jms.connection_factory");
        try {
            InitialContext initialContext = JNDIHelper.getInitialContext((Properties)properties, (String)"worker.jndi.");
            return (QueueConnectionFactory)initialContext.lookup(this.jmsConnectionFactoryName);
        }
        catch (NamingException e) {
            throw log.jmsLookupException(this.getJmsQueueName(), this.jmsConnectionFactoryName, this.getIndexName(), (Throwable)e);
        }
    }

    @Override
    protected Queue initializeJMSQueue(QueueConnectionFactory factory, Properties properties) {
        try {
            InitialContext initialContext = JNDIHelper.getInitialContext((Properties)properties, (String)"worker.jndi.");
            return (Queue)initialContext.lookup(this.getJmsQueueName());
        }
        catch (NamingException e) {
            throw log.jmsLookupException(this.getJmsQueueName(), this.jmsConnectionFactoryName, this.getIndexName(), (Throwable)e);
        }
    }

    @Override
    protected QueueConnection initializeJMSConnection(QueueConnectionFactory factory, Properties properties) {
        String login = properties.getProperty("worker.jms.login");
        String password = properties.getProperty("worker.jms.password");
        try {
            if (login == null && password == null) {
                return factory.createQueueConnection();
            }
            return factory.createQueueConnection(login, password);
        }
        catch (JMSException e) {
            throw log.unableToOpenJMSConnection(this.getIndexName(), this.getJmsQueueName(), (Throwable)e);
        }
    }
}

