/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.aws.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

class AWSPayloadHashingRequestInterceptor
implements HttpRequestInterceptor {
    public static final String CONTEXT_ATTRIBUTE_HASH = AWSPayloadHashingRequestInterceptor.class.getName() + "_hash";
    private static final OutputStream DISCARDING_STREAM = new OutputStream(){

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    };

    AWSPayloadHashingRequestInterceptor() {
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String contentHash = this.computeContentHash(request);
        context.setAttribute(CONTEXT_ATTRIBUTE_HASH, (Object)contentHash);
    }

    private String computeContentHash(HttpRequest request) throws IOException {
        HttpEntity entity = this.getEntity(request);
        if (entity == null) {
            return DigestUtils.sha256Hex((String)"");
        }
        if (!entity.isRepeatable()) {
            throw new IllegalStateException("Cannot sign AWS requests with non-repeatable entities");
        }
        MessageDigest digest = DigestUtils.getSha256Digest();
        DigestOutputStream digestStream = new DigestOutputStream(DISCARDING_STREAM, digest);
        entity.writeTo((OutputStream)digestStream);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private HttpEntity getEntity(HttpRequest request) throws IOException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)request).getEntity();
        }
        return null;
    }
}

