/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.aws.impl;

import java.util.Properties;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.hibernate.search.elasticsearch.aws.impl.AWSPayloadHashingRequestInterceptor;
import org.hibernate.search.elasticsearch.aws.impl.AWSSigningRequestInterceptor;
import org.hibernate.search.elasticsearch.client.spi.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;

public class AWSElasticsearchHttpClientConfigurer
implements ElasticsearchHttpClientConfigurer {
    private static final String SIGNING_ENABLED_PROPERTY = "elasticsearch.aws.signing.enabled";
    private static final String ACCESS_KEY_PROPERTY = "elasticsearch.aws.access_key";
    private static final String SECRET_KEY_PROPERTY = "elasticsearch.aws.secret_key";
    private static final String REGION_PROPERTY = "elasticsearch.aws.region";
    private static final String ELASTICSEARCH_SERVICE_NAME = "es";

    public void configure(HttpAsyncClientBuilder builder, Properties properties) {
        Boolean enabled = ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)SIGNING_ENABLED_PROPERTY, (boolean)false);
        if (!enabled.booleanValue()) {
            return;
        }
        String accessKey = this.requireNonEmpty(properties, ACCESS_KEY_PROPERTY);
        String secretKey = this.requireNonEmpty(properties, SECRET_KEY_PROPERTY);
        String region = this.requireNonEmpty(properties, REGION_PROPERTY);
        AWSPayloadHashingRequestInterceptor payloadHashingInterceptor = new AWSPayloadHashingRequestInterceptor();
        AWSSigningRequestInterceptor signingInterceptor = new AWSSigningRequestInterceptor(accessKey, secretKey, region, ELASTICSEARCH_SERVICE_NAME);
        builder.addInterceptorFirst((HttpRequestInterceptor)payloadHashingInterceptor);
        builder.addInterceptorLast((HttpRequestInterceptor)signingInterceptor);
    }

    private String requireNonEmpty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (StringHelper.isEmpty((String)value)) {
            throw new SearchException("Missing value for property '" + name + "'.");
        }
        return value;
    }
}

