/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.DateResolutionUtil;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.util.impl.EncodingStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchCalendarBridge
extends EncodingStringBridge<Calendar>
implements TwoWayFieldBridge,
ParameterizedBridge,
IgnoreAnalyzerBridge {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final ElasticsearchCalendarBridge DATE_YEAR = new ElasticsearchCalendarBridge(Resolution.YEAR);
    public static final ElasticsearchCalendarBridge DATE_MONTH = new ElasticsearchCalendarBridge(Resolution.MONTH);
    public static final ElasticsearchCalendarBridge DATE_DAY = new ElasticsearchCalendarBridge(Resolution.DAY);
    public static final ElasticsearchCalendarBridge DATE_HOUR = new ElasticsearchCalendarBridge(Resolution.HOUR);
    public static final ElasticsearchCalendarBridge DATE_MINUTE = new ElasticsearchCalendarBridge(Resolution.MINUTE);
    public static final ElasticsearchCalendarBridge DATE_SECOND = new ElasticsearchCalendarBridge(Resolution.SECOND);
    public static final ElasticsearchCalendarBridge DATE_MILLISECOND = new ElasticsearchCalendarBridge(Resolution.MILLISECOND);
    private DateTools.Resolution resolution;

    public ElasticsearchCalendarBridge() {
        this(Resolution.MILLISECOND);
    }

    public ElasticsearchCalendarBridge(Resolution resolution) {
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)resolution);
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        luceneOptions.addFieldToDocument(name, this.convertToString((Calendar)value), document);
    }

    public Object get(String name, Document document) {
        return this.convertFromString(document.get(name));
    }

    public String objectToString(Object object) {
        return this.convertToString((Calendar)object);
    }

    private String convertToString(Calendar value) {
        return ElasticsearchDateHelper.calendarToString(ElasticsearchDateHelper.round(value, this.resolution));
    }

    private Calendar convertFromString(String value) {
        return ElasticsearchDateHelper.stringToCalendar(value);
    }

    public void setParameterValues(Map<String, String> parameters) {
        String resolution = parameters.get("resolution");
        Resolution hibResolution = Resolution.valueOf((String)resolution.toUpperCase(Locale.ENGLISH));
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)hibResolution);
    }

    protected Calendar parseIndexNullAs(String indexNullAs) throws IllegalArgumentException {
        try {
            return this.convertFromString(indexNullAs);
        }
        catch (DateTimeParseException e) {
            throw LOG.invalidNullMarkerForCalendarAndDate(e);
        }
    }
}

