/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;

class ParallelChangesetsElasticsearchWorkOrchestrator
implements FlushableElasticsearchWorkOrchestrator {
    private final BulkAndSequenceAggregator aggregator;
    private final List<CompletableFuture<?>> sequenceFutures = new ArrayList();

    public ParallelChangesetsElasticsearchWorkOrchestrator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.aggregator = new BulkAndSequenceAggregator(sequenceBuilder, bulker);
    }

    @Override
    public CompletableFuture<Void> submit(Iterable<ElasticsearchWork<?>> nonBulkedWorks) {
        this.aggregator.initSequence();
        for (ElasticsearchWork<?> work : nonBulkedWorks) {
            work.aggregate(this.aggregator);
        }
        CompletableFuture<Void> future = this.aggregator.flushSequence();
        this.sequenceFutures.add(future);
        return future;
    }

    @Override
    public CompletableFuture<Void> flush() {
        CompletableFuture<Void> future = CompletableFuture.allOf(this.sequenceFutures.toArray(new CompletableFuture[this.sequenceFutures.size()]));
        this.sequenceFutures.clear();
        this.aggregator.startSequences();
        return future;
    }

    @Override
    public void reset() {
        this.aggregator.reset();
        this.sequenceFutures.clear();
    }

    private static class BulkAndSequenceAggregator
    implements ElasticsearchWorkAggregator {
        private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
        private final ElasticsearchWorkBulker bulker;
        private CompletableFuture<Void> rootFuture = CompletableFuture.completedFuture(null);
        private boolean currentBulkIsUsableInSameSequence = true;

        public BulkAndSequenceAggregator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
            this.sequenceBuilder = sequenceBuilder;
            this.bulker = bulker;
        }

        public void initSequence() {
            this.sequenceBuilder.init(this.rootFuture);
        }

        @Override
        public void addBulkable(BulkableElasticsearchWork<?> work) {
            if (!this.currentBulkIsUsableInSameSequence) {
                this.bulker.flushBulk();
                this.currentBulkIsUsableInSameSequence = true;
            }
            this.bulker.add(work);
        }

        @Override
        public void addNonBulkable(ElasticsearchWork<?> work) {
            if (this.bulker.flushBulked()) {
                this.currentBulkIsUsableInSameSequence = false;
            }
            this.sequenceBuilder.addNonBulkExecution(work);
        }

        public CompletableFuture<Void> flushSequence() {
            this.bulker.flushBulked();
            CompletableFuture<Void> future = this.sequenceBuilder.build();
            this.currentBulkIsUsableInSameSequence = true;
            return future;
        }

        public void startSequences() {
            this.bulker.flushBulk();
        }

        public void reset() {
            this.bulker.reset();
            this.rootFuture = CompletableFuture.completedFuture(null);
            this.sequenceBuilder.init(this.rootFuture);
        }
    }
}

