/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.exception.SearchException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchQueriesTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void valid() {
        ElasticsearchQueries.fromJson((String)"{'query':{'match_all':{}}}");
    }

    @Test
    public void invalidAttribute() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400051");
        ElasticsearchQueries.fromJson((String)"{'aggs' : {'avg_grade' : { 'avg' : { 'field' : 'grade' } }}}");
    }

    @Test
    public void malformatedJson() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400052");
        ElasticsearchQueries.fromJson((String)"{ 'query': }");
    }

    @Test
    public void nonObjectJson() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400052");
        ElasticsearchQueries.fromJson((String)"'foo'");
    }
}

