/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.JsonLogHelper;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class LogTest {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Gson GSON = new Gson();
    private static final String NON_EMPTY_JSON_OBJECT_1_AS_STRING = "{\"property\":{\"subProperty\":\"value1\"}}";
    private static final JsonObject NON_EMPTY_JSON_OBJECT_1 = (JsonObject)GSON.fromJson("{\"property\":{\"subProperty\":\"value1\"}}", JsonObject.class);
    private static final String NON_EMPTY_JSON_OBJECT_2_AS_STRING = "{\"property\":{\"subProperty\":\"value2\"}}";
    private static final JsonObject NON_EMPTY_JSON_OBJECT_2 = (JsonObject)GSON.fromJson("{\"property\":{\"subProperty\":\"value2\"}}", JsonObject.class);

    @Test
    public void jsonObjectList_prettyPrinting() {
        JsonLogHelper logHelper = JsonLogHelper.create((GsonBuilder)new GsonBuilder(), (boolean)true);
        Assertions.assertThat((String)logHelper.toString(Arrays.asList(NON_EMPTY_JSON_OBJECT_1, NON_EMPTY_JSON_OBJECT_2))).isEqualTo((Object)"\n{\n  \"property\": {\n    \"subProperty\": \"value1\"\n  }\n}\n{\n  \"property\": {\n    \"subProperty\": \"value2\"\n  }\n}\n");
    }

    @Test
    public void jsonObjectList_noPrettyPrinting() {
        JsonLogHelper logHelper = JsonLogHelper.create((GsonBuilder)new GsonBuilder(), (boolean)false);
        Assertions.assertThat((String)logHelper.toString(Arrays.asList(NON_EMPTY_JSON_OBJECT_1, NON_EMPTY_JSON_OBJECT_2))).isEqualTo((Object)"{\"property\":{\"subProperty\":\"value1\"}}\\n{\"property\":{\"subProperty\":\"value2\"}}");
    }

    @Test
    public void elasticsearchRequestFailed() {
        ElasticsearchRequest request = ElasticsearchRequest.head().pathComponent(URLEncodedString.fromString((String)"foo")).pathComponent(URLEncodedString.fromString((String)"bar")).param("param1", "value1").param("param2", "value2").body(NON_EMPTY_JSON_OBJECT_1).body(NON_EMPTY_JSON_OBJECT_1).build();
        ElasticsearchResponse response = new ElasticsearchResponse(454, "A status message", NON_EMPTY_JSON_OBJECT_2);
        Exception cause = new Exception();
        SearchException result = log.elasticsearchRequestFailed(request, response, cause);
        Assert.assertThat((Object)result, (Matcher)ExceptionMatcherBuilder.isException(SearchException.class).withMessage(CoreMatchers.equalTo((Object)"HSEARCH400007: Elasticsearch request failed.\nRequest: HEAD /foo/bar with parameters {param1=value1, param2=value2}\nResponse: 454 'A status message' with body \n{\n  \"property\": {\n    \"subProperty\": \"value2\"\n  }\n}\n")).causedBy((Throwable)cause).build());
    }

    @Test
    public void elasticsearchRequestFailed_nullResponse() {
        ElasticsearchRequest request = ElasticsearchRequest.head().pathComponent(URLEncodedString.fromString((String)"foo")).pathComponent(URLEncodedString.fromString((String)"bar")).param("param1", "value1").param("param2", "value2").body(NON_EMPTY_JSON_OBJECT_1).body(NON_EMPTY_JSON_OBJECT_1).build();
        Exception cause = new Exception();
        SearchException result = log.elasticsearchRequestFailed(request, null, cause);
        Assert.assertThat((Object)result, (Matcher)ExceptionMatcherBuilder.isException(SearchException.class).withMessage(CoreMatchers.equalTo((Object)"HSEARCH400007: Elasticsearch request failed.\nRequest: HEAD /foo/bar with parameters {param1=value1, param2=value2}\nResponse: null")).causedBy((Throwable)cause).build());
    }

    @Test
    public void elasticsearchBulkedRequestFailed() {
        JsonObject requestMetadata = NON_EMPTY_JSON_OBJECT_1;
        JsonObject response = NON_EMPTY_JSON_OBJECT_2;
        Exception cause = new Exception();
        SearchException result = log.elasticsearchBulkedRequestFailed(requestMetadata, response, cause);
        Assert.assertThat((Object)result, (Matcher)ExceptionMatcherBuilder.isException(SearchException.class).withMessage(CoreMatchers.equalTo((Object)"HSEARCH400008: Elasticsearch bulked request failed.\nRequest metadata: \n{\n  \"property\": {\n    \"subProperty\": \"value1\"\n  }\n}\nResponse: \n{\n  \"property\": {\n    \"subProperty\": \"value2\"\n  }\n}\n")).causedBy((Throwable)cause).build());
    }

    @Test
    public void elasticsearchBulkedRequestFailed_nullResponse() {
        JsonObject requestMetadata = NON_EMPTY_JSON_OBJECT_1;
        Exception cause = new Exception();
        SearchException result = log.elasticsearchBulkedRequestFailed(requestMetadata, null, cause);
        Assert.assertThat((Object)result, (Matcher)ExceptionMatcherBuilder.isException(SearchException.class).withMessage(CoreMatchers.equalTo((Object)"HSEARCH400008: Elasticsearch bulked request failed.\nRequest metadata: \n{\n  \"property\": {\n    \"subProperty\": \"value1\"\n  }\n}\nResponse: \nnull\n")).causedBy((Throwable)cause).build());
    }
}

