/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.DateResolutionUtil;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.util.impl.EncodingStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchDateBridge
extends EncodingStringBridge<Date>
implements TwoWayFieldBridge,
ParameterizedBridge,
IgnoreAnalyzerBridge {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final ElasticsearchDateBridge DATE_YEAR = new ElasticsearchDateBridge(Resolution.YEAR);
    public static final ElasticsearchDateBridge DATE_MONTH = new ElasticsearchDateBridge(Resolution.MONTH);
    public static final ElasticsearchDateBridge DATE_DAY = new ElasticsearchDateBridge(Resolution.DAY);
    public static final ElasticsearchDateBridge DATE_HOUR = new ElasticsearchDateBridge(Resolution.HOUR);
    public static final ElasticsearchDateBridge DATE_MINUTE = new ElasticsearchDateBridge(Resolution.MINUTE);
    public static final ElasticsearchDateBridge DATE_SECOND = new ElasticsearchDateBridge(Resolution.SECOND);
    public static final ElasticsearchDateBridge DATE_MILLISECOND = new ElasticsearchDateBridge(Resolution.MILLISECOND);
    private DateTools.Resolution resolution;

    public ElasticsearchDateBridge() {
        this(Resolution.MILLISECOND);
    }

    public ElasticsearchDateBridge(Resolution resolution) {
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)resolution);
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        luceneOptions.addFieldToDocument(name, this.convertToString((Date)value), document);
    }

    public Object get(String name, Document document) {
        return this.convertFromString(document.get(name));
    }

    public String objectToString(Object object) {
        return this.convertToString((Date)object);
    }

    private String convertToString(Date value) {
        return value == null ? null : ElasticsearchDateHelper.dateToString(DateTools.round((Date)value, (DateTools.Resolution)this.resolution));
    }

    private Date convertFromString(String value) {
        return value == null ? null : ElasticsearchDateHelper.stringToDate(value);
    }

    public void setParameterValues(Map<String, String> parameters) {
        String resolution = parameters.get("resolution");
        Resolution hibResolution = Resolution.valueOf((String)resolution.toUpperCase(Locale.ENGLISH));
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)hibResolution);
    }

    protected Date parseIndexNullAs(String indexNullAs) throws IllegalArgumentException {
        try {
            return this.convertFromString(indexNullAs);
        }
        catch (DateTimeParseException e) {
            throw LOG.invalidNullMarkerForCalendarAndDate(e);
        }
    }
}

