/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.elasticsearch.impl.ElasticsearchHSQueryImpl;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;

public class ElasticsearchJsonQueryDescriptor
implements QueryDescriptor {
    private final JsonObject rawSearchPayload;

    public ElasticsearchJsonQueryDescriptor(JsonObject rawSearchPayload) {
        this.rawSearchPayload = rawSearchPayload;
    }

    public HSQuery createHSQuery(SearchIntegrator integrator, IndexedTypeSet types) {
        return new ElasticsearchHSQueryImpl(this.rawSearchPayload, (ExtendedSearchIntegrator)integrator.unwrap(ExtendedSearchIntegrator.class), types);
    }

    public HSQuery createHSQuery(SearchIntegrator integrator, List<CustomTypeMetadata> types) {
        return new ElasticsearchHSQueryImpl(this.rawSearchPayload, (ExtendedSearchIntegrator)integrator.unwrap(ExtendedSearchIntegrator.class), types);
    }

    public String toString() {
        return this.rawSearchPayload.toString();
    }
}

