/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Supplier;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;

public class DefaultGsonProvider
implements GsonProvider {
    protected static final String ELASTIC_SEARCH_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final Gson gson;
    private final Gson gsonNoSerializeNulls;

    public static GsonProvider create(Supplier<GsonBuilder> builderBaseSupplier) {
        return new DefaultGsonProvider(builderBaseSupplier);
    }

    private DefaultGsonProvider(Supplier<GsonBuilder> builderBaseSupplier) {
        this.gson = builderBaseSupplier.get().serializeNulls().create();
        this.gsonNoSerializeNulls = builderBaseSupplier.get().create();
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public Gson getGsonNoSerializeNulls() {
        return this.gsonNoSerializeNulls;
    }
}

