/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.bridge.spi.IndexManagerTypeSpecificBridgeProvider;
import org.hibernate.search.elasticsearch.bridge.impl.ElasticsearchJavaTimeBridgeProvider;
import org.hibernate.search.elasticsearch.bridge.impl.ElasticsearchJavaUtilTimeBridgeProvider;
import org.hibernate.search.elasticsearch.bridge.impl.ElasticsearchPrimitiveBridgeProvider;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.indexes.spi.IndexManagerType;

public class ElasticsearchBridgeProvider
implements IndexManagerTypeSpecificBridgeProvider {
    private final List<BridgeProvider> delegates = new ArrayList<BridgeProvider>();

    public ElasticsearchBridgeProvider() {
        this.delegates.add(new ElasticsearchPrimitiveBridgeProvider());
        this.delegates.add((BridgeProvider)new ElasticsearchJavaUtilTimeBridgeProvider());
        this.delegates.add(new ElasticsearchJavaTimeBridgeProvider());
    }

    public IndexManagerType getIndexManagerType() {
        return ElasticsearchIndexManagerType.INSTANCE;
    }

    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext context) {
        for (BridgeProvider delegate : this.delegates) {
            FieldBridge delegateResult = delegate.provideFieldBridge(context);
            if (delegateResult == null) continue;
            return delegateResult;
        }
        return null;
    }
}

