/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.jgroups.BackendMessage;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;

public class JGroupsBackendQueueTask {
    private static final Log log = LoggerFactory.make();
    private final JGroupsBackendQueueProcessor factory;
    private final String indexName;
    private final IndexManager indexManager;

    public JGroupsBackendQueueTask(JGroupsBackendQueueProcessor factory, IndexManager indexManager) {
        this.factory = factory;
        this.indexManager = indexManager;
        this.indexName = indexManager.getIndexName();
    }

    public void sendLuceneWorkList(List<LuceneWork> queue) {
        boolean trace = log.isTraceEnabled();
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(queue);
        if (trace) {
            log.tracef("Preparing %d Lucene works to be sent to master node.", filteredQueue.size());
        }
        for (LuceneWork work : queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (trace) {
            log.tracef("Filtering: optimized Lucene works are not going to be sent to master node. There is %d Lucene works after filtering.", filteredQueue.size());
        }
        if (filteredQueue.isEmpty()) {
            if (trace) {
                log.trace("Nothing to send. Propagating works to a cluster has been skipped.");
            }
            return;
        }
        byte[] data = this.indexManager.getSerializer().toSerializedModel(filteredQueue);
        BackendMessage toSend = new BackendMessage(this.indexName, data);
        try {
            Message message = new Message(null, this.factory.getAddress(), (Object)toSend);
            this.factory.getChannel().send(message);
            if (trace) {
                log.tracef("Lucene works have been sent from slave %s to master node.", this.factory.getAddress());
            }
        }
        catch (ChannelNotConnectedException e) {
            throw new SearchException("Unable to send Lucene work. Channel is not connected to: " + this.factory.getClusterName());
        }
        catch (ChannelClosedException e) {
            throw new SearchException("Unable to send Lucene work. Attempt to send message on closed JGroups channel");
        }
    }
}

