/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.net.URL;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TestConstants {
    private static final Log log;
    public static final Analyzer standardAnalyzer;
    public static final Analyzer stopAnalyzer;
    public static final Analyzer simpleAnalyzer;
    public static final Analyzer keywordAnalyzer;
    private static File targetDir;
    private static final String indexDirPath;

    public static Version getTargetLuceneVersion() {
        return Version.LUCENE_CURRENT;
    }

    public static File getTargetDir() {
        return targetDir;
    }

    public static String getIndexDirectory() {
        return indexDirPath;
    }

    static {
        File myPath;
        log = LoggerFactory.make();
        standardAnalyzer = new StandardAnalyzer(TestConstants.getTargetLuceneVersion());
        stopAnalyzer = new StopAnalyzer(TestConstants.getTargetLuceneVersion());
        simpleAnalyzer = new SimpleAnalyzer(TestConstants.getTargetLuceneVersion());
        keywordAnalyzer = new KeywordAnalyzer();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentTestName = new RuntimeException().getStackTrace()[2].getClassName();
        int hopsToRoot = currentTestName.split("\\.").length + 1;
        URL myUrl = contextClassLoader.getResource(currentTestName.replace('.', '/') + ".class");
        targetDir = myPath = new File(myUrl.getFile());
        for (int i = 0; i < hopsToRoot + 2; ++i) {
            targetDir = myPath.getParentFile();
        }
        indexDirPath = targetDir.getAbsolutePath() + File.separator + "indextemp";
        log.debugf("Using %s as index directory.", (Object)indexDirPath);
    }
}

