/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.Properties;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.impl.SimpleInitializer;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.spi.WorkerBuildContext;

public class RamIndexManager
extends DirectoryBasedIndexManager {
    private static final LogErrorHandler logErrorHandler = new LogErrorHandler();

    public static RamIndexManager makeRamDirectory() {
        RamIndexManager ramIndexManager = new RamIndexManager();
        Properties properties = new Properties();
        properties.setProperty("directory_provider", "ram");
        ramIndexManager.initialize("testIndex", properties, new EmptyWorkerBuildContext());
        return ramIndexManager;
    }

    private static class EmptyWorkerBuildContext
    implements WorkerBuildContext {
        private EmptyWorkerBuildContext() {
        }

        public SearchFactoryImplementor getUninitializedSearchFactory() {
            return null;
        }

        public String getIndexingStrategy() {
            return null;
        }

        public <T> T requestService(Class<? extends ServiceProvider<T>> provider) {
            return null;
        }

        public void releaseService(Class<? extends ServiceProvider<?>> provider) {
        }

        public IndexManagerHolder getAllIndexesManager() {
            return null;
        }

        public ErrorHandler getErrorHandler() {
            return logErrorHandler;
        }

        public boolean isTransactionManagerExpected() {
            return false;
        }

        public InstanceInitializer getInstanceInitializer() {
            return new SimpleInitializer();
        }
    }
}

