/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.util.impl.ContextualException2WayBridge;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DocumentBuilderHelper {
    private static final Log log = LoggerFactory.make();
    private static final Object NOT_SET = new Object();

    private DocumentBuilderHelper() {
    }

    public static Class getDocumentClass(String className) {
        try {
            return ReflectHelper.classForName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = DocumentBuilderHelper.getDocumentBuilder(searchFactoryImplementor, clazz);
        TwoWayFieldBridge fieldBridge = builderIndexedEntity.getIdBridge();
        String fieldName = builderIndexedEntity.getIdKeywordName();
        ContextualException2WayBridge contextualBridge = new ContextualException2WayBridge();
        ((ContextualException2WayBridge)contextualBridge.setClass((Class)clazz)).setFieldName(fieldName).setFieldBridge(fieldBridge).pushIdentifierMethod();
        return (Serializable)contextualBridge.get(fieldName, document);
    }

    public static String getDocumentIdName(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz) {
        DocumentBuilderIndexedEntity<?> documentBuilder = DocumentBuilderHelper.getDocumentBuilder(searchFactoryImplementor, clazz);
        return documentBuilder.getIdentifierName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getDocumentFields(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document, String[] fields) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = DocumentBuilderHelper.getDocumentBuilder(searchFactoryImplementor, clazz);
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        Arrays.fill(result, NOT_SET);
        ContextualException2WayBridge contextualBridge = new ContextualException2WayBridge();
        contextualBridge.setClass((Class)clazz);
        if (builderIndexedEntity.getIdKeywordName() != null) {
            XMember member = builderIndexedEntity.getIdGetter();
            String fieldName = builderIndexedEntity.getIdKeywordName();
            int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName);
            if (matchingPosition != -1) {
                if (member != null) {
                    contextualBridge.pushMethod(member);
                }
                try {
                    DocumentBuilderHelper.populateResult(fieldName, builderIndexedEntity.getIdBridge(), Store.YES, result, document, contextualBridge, matchingPosition);
                }
                finally {
                    if (member != null) {
                        contextualBridge.popMethod();
                    }
                }
            }
        }
        AbstractDocumentBuilder.PropertiesMetadata metadata = builderIndexedEntity.getMetadata();
        DocumentBuilderHelper.processFieldsForProjection(metadata, fields, result, document, contextualBridge);
        return result;
    }

    public static void populateResult(String fieldName, FieldBridge fieldBridge, Store store, Object[] result, Document document, ContextualException2WayBridge contextualBridge, int matchingPosition) {
        if (store != Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
            contextualBridge.setFieldName(fieldName).setFieldBridge((TwoWayFieldBridge)fieldBridge);
            result[matchingPosition] = contextualBridge.get(fieldName, document);
            if (log.isTraceEnabled()) {
                log.tracef("Field %s projected as %s", fieldName, result[matchingPosition]);
            }
        } else {
            if (store == Store.NO) {
                throw new SearchException("Projecting an unstored field: " + fieldName);
            }
            throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFieldsForProjection(AbstractDocumentBuilder.PropertiesMetadata metadata, String[] fields, Object[] result, Document document, ContextualException2WayBridge contextualBridge) {
        int index;
        int nbrFoEntityFields = metadata.fieldNames.size();
        for (int index2 = 0; index2 < nbrFoEntityFields; ++index2) {
            String fieldName = metadata.fieldNames.get(index2);
            int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName);
            if (matchingPosition == -1) continue;
            contextualBridge.pushMethod(metadata.fieldGetters.get(index2));
            try {
                DocumentBuilderHelper.populateResult(fieldName, metadata.fieldBridges.get(index2), metadata.fieldStore.get(index2), result, document, contextualBridge, matchingPosition);
                continue;
            }
            finally {
                contextualBridge.popMethod();
            }
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index3 = 0; index3 < nbrOfEmbeddedObjects; ++index3) {
            if (metadata.embeddedContainers.get(index3) != AbstractDocumentBuilder.PropertiesMetadata.Container.OBJECT) continue;
            contextualBridge.pushMethod(metadata.embeddedGetters.get(index3));
            DocumentBuilderHelper.processFieldsForProjection(metadata.embeddedPropertiesMetadata.get(index3), fields, result, document, contextualBridge);
            contextualBridge.popMethod();
        }
        int nbrOfClassBridges = metadata.classBridges.size();
        for (index = 0; index < nbrOfClassBridges; ++index) {
            String fieldName = metadata.classNames.get(index);
            int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName);
            if (matchingPosition == -1) continue;
            DocumentBuilderHelper.populateResult(fieldName, metadata.classBridges.get(index), metadata.classStores.get(index), result, document, contextualBridge, matchingPosition);
        }
        for (index = 0; index < result.length; ++index) {
            Fieldable field;
            if (result[index] != NOT_SET) continue;
            result[index] = null;
            if (document == null || (field = document.getFieldable(fields[index])) == null) continue;
            result[index] = DocumentBuilderHelper.extractStringFromFieldable(field);
        }
    }

    public static String extractStringFromFieldable(Fieldable field) {
        if (field.isBinary()) {
            try {
                return CompressionTools.decompressString((byte[])field.getBinaryValue());
            }
            catch (DataFormatException e) {
                throw log.fieldLooksBinaryButDecompressionFailed(field.name());
            }
        }
        return field.stringValue();
    }

    public static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }

    private static DocumentBuilderIndexedEntity<?> getDocumentBuilder(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz) {
        EntityIndexBinder entityIndexBinding = searchFactoryImplementor.getIndexBindingForEntity(clazz);
        if (entityIndexBinding == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz);
        }
        return entityIndexBinding.getDocumentBuilder();
    }
}

