/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.net.URL;
import java.util.Properties;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.XMLHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;

public abstract class JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    public static final String JGROUPS_PREFIX = "worker.backend.jgroups.";
    public static final String CONFIGURATION_STRING = "worker.backend.jgroups.configurationString";
    public static final String CONFIGURATION_XML = "worker.backend.jgroups.configurationXml";
    public static final String CONFIGURATION_FILE = "worker.backend.jgroups.configurationFile";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    public static final String JG_CLUSTER_NAME = "worker.backend.jgroups.clusterName";
    protected String clusterName = "HSearchCluster";
    protected Channel channel = null;
    protected Address address;
    protected String indexName;
    protected DirectoryBasedIndexManager indexManager;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexManager = indexManager;
        this.indexName = indexManager.getIndexName();
        if (props.containsKey(JG_CLUSTER_NAME)) {
            this.setClusterName(props.getProperty(JG_CLUSTER_NAME));
        }
        this.prepareJGroupsChannel(props);
    }

    private void prepareJGroupsChannel(Properties props) {
        log.jGroupsStartingChannel();
        try {
            this.buildChannel(props);
            this.channel.connect(this.clusterName);
        }
        catch (Exception e) {
            throw log.unabletoConnectToJGroupsCluster(this.clusterName, e);
        }
        log.jGroupsConnectedToCluster(this.clusterName, this.getAddress());
        if (!this.channel.flushSupported()) {
            log.jGroupsFlushNotPresentInStack();
        }
    }

    private void buildChannel(Properties props) {
        if (props != null) {
            String cfg;
            if (props.containsKey(CONFIGURATION_FILE)) {
                cfg = props.getProperty(CONFIGURATION_FILE);
                try {
                    this.channel = new JChannel(ConfigurationParseHelper.locateConfig(cfg));
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingFileError(cfg, e);
                }
            }
            if (props.containsKey(CONFIGURATION_XML)) {
                cfg = props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XMLHelper.elementFromString(cfg));
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingXmlError(cfg, e);
                }
            }
            if (props.containsKey(CONFIGURATION_STRING)) {
                cfg = props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel(cfg);
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationFromStringError(cfg, e);
                }
            }
        }
        if (this.channel == null) {
            log.jGroupsConfigurationNotFoundInProperties(props);
            try {
                URL fileUrl = ConfigurationParseHelper.locateConfig(DEFAULT_JGROUPS_CONFIGURATION_FILE);
                if (fileUrl != null) {
                    this.channel = new JChannel(fileUrl);
                } else {
                    log.jGroupsDefaultConfigurationFileNotFound();
                    this.channel = new JChannel();
                }
            }
            catch (Exception e) {
                throw log.unableToStartJGroupsChannel(e);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                log.jGroupsDisconnectingAndClosingChannel();
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.jGroupsClosingChannelError(toLog);
            this.channel = null;
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Address getAddress() {
        if (this.address == null && this.channel != null) {
            this.address = this.channel.getAddress();
        }
        return this.address;
    }
}

