/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.FuzzyContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

class ConnectedFuzzyContext
implements FuzzyContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;

    public ConnectedFuzzyContext(QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryCustomizer = queryCustomizer;
        this.termContext = new TermQueryContext(TermQueryContext.Approximation.FUZZY);
        this.queryContext = queryContext;
    }

    @Override
    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.termContext, field, this.queryCustomizer, this.queryContext);
    }

    @Override
    public ConnectedFuzzyContext withThreshold(float threshold) {
        this.termContext.setThreshold(threshold);
        return this;
    }

    @Override
    public ConnectedFuzzyContext withPrefixLength(int prefixLength) {
        this.termContext.setPrefixLength(prefixLength);
        return this;
    }

    @Override
    public FuzzyContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public FuzzyContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public FuzzyContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

