/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;

public class ClassLoaderHelper {
    private ClassLoaderHelper() {
    }

    public static Enumeration<URL> getResources(String resourceName, Class<?> caller) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = caller.getClassLoader();
        }
        try {
            return loader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new SearchException("Unable to load resource " + resourceName, e);
        }
    }

    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, Class<?> caller, String componentDescription) {
        Class<?> clazzDef = ClassLoaderHelper.classForName(classNameToLoad, caller, componentDescription);
        return ClassLoaderHelper.instanceFromClass(targetSuperType, clazzDef, componentDescription);
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription) {
        Object instance;
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        ClassLoaderHelper.checkHasNoArgConstructor(classToLoad, componentDescription);
        try {
            instance = classToLoad.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Class or constructor is not accessible.", e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Verify it has a no-args public constructor and is not abstract.", e);
        }
        if (!targetSuperType.isInstance(instance)) {
            if (targetSuperType.isInterface()) {
                throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " does not implement interface " + targetSuperType.getName());
            }
            throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " is not a subtype of " + targetSuperType.getName());
        }
        return (T)instance;
    }

    public static Analyzer analyzerInstanceFromClass(Class<?> classToInstantiate, Version luceneMatchVersion) {
        Analyzer analyzerInstance;
        Constructor<?> constructor;
        ClassLoaderHelper.checkClassType(classToInstantiate, "analyzer");
        boolean useVersionParameter = true;
        try {
            constructor = classToInstantiate.getConstructor(Version.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = classToInstantiate.getConstructor(new Class[0]);
                useVersionParameter = false;
            }
            catch (NoSuchMethodException nsme) {
                StringBuilder msg = new StringBuilder("Unable to instantiate analyzer class: ");
                msg.append(classToInstantiate.getName());
                msg.append(". Class neither has a default constructor nor a constructor with a Version parameter");
                throw new SearchException(msg.toString(), e);
            }
        }
        try {
            analyzerInstance = useVersionParameter ? (Analyzer)constructor.newInstance(luceneMatchVersion) : (Analyzer)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Class or constructor is not accessible.", e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Verify it has a no-args public constructor and is not abstract.", e);
        }
        catch (InvocationTargetException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Verify it has a no-args public constructor and is not abstract." + " Also Analyzer implementation classes or their tokenStream() and reusableTokenStream() implementations must be final.", e);
        }
        return analyzerInstance;
    }

    private static void checkClassType(Class<?> classToLoad, String componentDescription) {
        if (classToLoad.isInterface()) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is an interface: implementation required.");
        }
    }

    private static void checkHasNoArgConstructor(Class<?> classToLoad, String componentDescription) {
        try {
            classToLoad.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " could not be instantiated because of a security manager error", e);
        }
        catch (NoSuchMethodException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is missing a no-arguments constructor");
        }
    }

    public static Class<?> classForName(String classNameToLoad, Class<?> caller, String componentDescription) {
        Class clazzDef;
        try {
            clazzDef = ReflectHelper.classForName((String)classNameToLoad, caller);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to find " + componentDescription + " implementation class: " + classNameToLoad, e);
        }
        return clazzDef;
    }
}

