/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.programmaticmapping;

import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.rules.ExternalResource;

public class TestingSearchFactoryHolder
extends ExternalResource {
    private final SearchMapping buildMappingDefinition;
    private SearchFactoryImplementor sf;

    public TestingSearchFactoryHolder(SearchMapping buildMappingDefinition) {
        this.buildMappingDefinition = buildMappingDefinition;
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.sf;
    }

    protected void before() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setProgrammaticMapping(this.buildMappingDefinition);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        this.sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
    }

    protected void after() {
        this.sf.close();
    }
}

