/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ServiceManager {
    private static final String SERVICES_FILE = "META-INF/services/" + ServiceProvider.class.getName();
    private static final Log log = LoggerFactory.make();
    private final HashSet<Class<?>> availableProviders = new HashSet();
    private final ConcurrentHashMap<Class<?>, ServiceProviderWrapper> managedProviders = new ConcurrentHashMap();
    private final Map<Class<? extends ServiceProvider<?>>, Object> providedProviders = new HashMap();
    private final Properties properties;

    public ServiceManager(SearchConfiguration cfg) {
        this.properties = cfg.getProperties();
        this.providedProviders.putAll(cfg.getProvidedServices());
        this.listAndInstantiateServiceProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listAndInstantiateServiceProviders() {
        Enumeration<URL> resources = ClassLoaderHelper.getResources(SERVICES_FILE, ServiceManager.class);
        try {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
                    String name = reader.readLine();
                    while (name != null) {
                        if (!(name = name.trim()).startsWith("#")) {
                            Class<?> serviceProviderClass = ClassLoaderHelper.classForName(name, ServiceManager.class, "service provider");
                            this.availableProviders.add(serviceProviderClass);
                        }
                        name = reader.readLine();
                    }
                }
                finally {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SearchException("Unable to read " + SERVICES_FILE, e);
        }
    }

    public <T> T requestService(Class<? extends ServiceProvider<T>> serviceProviderClass, BuildContext context) {
        if (this.providedProviders.containsKey(serviceProviderClass)) {
            return (T)this.providedProviders.get(serviceProviderClass);
        }
        ServiceProviderWrapper wrapper = this.managedProviders.get(serviceProviderClass);
        if (wrapper == null) {
            if (this.availableProviders.contains(serviceProviderClass)) {
                ServiceProvider serviceProvider = ClassLoaderHelper.instanceFromClass(ServiceProvider.class, serviceProviderClass, "service provider");
                wrapper = new ServiceProviderWrapper(serviceProvider, context);
                this.managedProviders.putIfAbsent(serviceProviderClass, wrapper);
            } else {
                throw new SearchException("Unable to find service related to " + serviceProviderClass);
            }
        }
        wrapper = this.managedProviders.get(serviceProviderClass);
        wrapper.increaseCounter();
        return (T)wrapper.getServiceProvider().getService();
    }

    public void releaseService(Class<? extends ServiceProvider<?>> serviceProviderClass) {
        if (this.providedProviders.containsKey(serviceProviderClass)) {
            return;
        }
        ServiceProviderWrapper wrapper = this.managedProviders.get(serviceProviderClass);
        if (wrapper == null) {
            throw new SearchException("Unable to find service related to " + serviceProviderClass);
        }
        wrapper.decreaseCounter();
    }

    public void stopServices() {
        for (ServiceProviderWrapper wrapper : this.managedProviders.values()) {
            if (wrapper.getCounter() != 0) {
                log.serviceProviderNotReleased(wrapper.getServiceProvider().getClass());
            }
            try {
                wrapper.getServiceProvider().stop();
            }
            catch (Exception e) {
                log.stopServiceFailed(wrapper.getServiceProvider().getClass(), e);
            }
        }
    }

    private class ServiceProviderWrapper {
        private final ServiceProvider<?> serviceProvider;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final BuildContext context;

        public ServiceProviderWrapper(ServiceProvider<?> serviceProvider, BuildContext context) {
            this.serviceProvider = serviceProvider;
            this.context = context;
        }

        public ServiceProvider<?> getServiceProvider() {
            return this.serviceProvider;
        }

        synchronized void increaseCounter() {
            int oldValue = this.counter.getAndIncrement();
            if (oldValue == 0) {
                this.serviceProvider.start(ServiceManager.this.properties, this.context);
            }
        }

        int getCounter() {
            return this.counter.get();
        }

        void decreaseCounter() {
            this.counter.getAndDecrement();
        }
    }
}

