
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Generated;
import org.apache.lucene.index.CorruptIndexException;
import org.hibernate.annotations.common.reflection.XClass;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.model.MessageLoggerImplementor", date = "2013-01-15T14:04:51+0000")
public class Log_$logger
    extends DelegatingBasicLogger
    implements Serializable, Log, BasicLogger
{

    private final static long serialVersionUID = 1L;
    private final static String projectCode = "HSEARCH";
    private final static String FQCN = Log_$logger.class.getName();
    private final static String unableToDeserializeAvroStream = "Unable to deserialize Avro stream";
    private final static String noFieldBridgeInterfaceImplementedByFieldBridge = "@FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s";
    private final static String requestedIndexNotDefined = "Index names %1$s is not defined";
    private final static String unexpectedErrorInLuceneBackend = "Unexpected error in Lucene Backend:";
    private final static String indexingDocumentsCompleted = "%1$d documents indexed in %2$d ms";
    private final static String shuttingDownBackend = "Shutting down backend for IndexManager '%1$s'";
    private final static String cannotGuessTransactionStatus = "Cannot guess the Transaction Status: not starting a JTA transaction";
    private final static String unableToConvertSerializableTermVectorToLuceneTermVector = "Unable to convert serializable TermVector to Lucene TermVector: %1$s";
    private final static String needAtLeastOneIndexedEntityType = "At least one entity type must be provided: can't open an IndexReader on nothing";
    private final static String workerException = "Worker raises an exception on close()";
    private final static String cannotExtractCoordinateFromObject = "Class %1$s does not implement the Coordinates interface";
    private final static String failToDeserializeObject = "Fail to deserialize object";
    private final static String exceptionDuringIndexMergeOperation = "Exception during index Merge operation";
    private final static String spatialFieldNameNotDefined = "Spatial field name not defined for class level annotation on class %1$s";
    private final static String unableToRetrieveObjectFromMessage = "Unable to retrieve object from message: %1$s";
    private final static String unableToConfigureTikaBridge = "Unable to configure %1$s";
    private final static String cannotFindCoordinatesNorLatLongForSpatial = "Cannot find a Coordinates Interface nor Lat/Long annotations bound to %1$s @Spatial for class %2$s";
    private final static String indexingCompletedAndMBeanUnregistered = "Indexing completed. Reindexed %1$d entities. Unregistering MBean from server";
    private final static String fieldBridgeNotTwoWay = "FieldBridge '%1$s' does not have a objectToString method: field '%2$s' in '%3$s' The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query";
    private final static String massIndexerUnexpectedErrorMessage = "Unexpected error during MassIndexer operation";
    private final static String unableToReadSerializedLuceneWorks = "Unable to read serialized List<LuceneWork>";
    private final static String cantOpenCorruptedIndex = "Could not open Lucene index: index data is corrupted. index name: '%1$s'";
    private final static String inconsistentFieldConfiguration = "There are multiple properties indexed against the same field name '%1$s', but with different indexing settings. The behaviour is undefined.";
    private final static String jGroupsReceivedNewClusterView = "Received new cluster view: %1$s";
    private final static String unexpectedValueMissingFromFieldCache = "Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.";
    private final static String failedSlaveDirectoryProviderInitialization = "Failed to initialize SlaveDirectoryProvider %1$s";
    private final static String unknownFieldType = "Unknown Field type: %1$s";
    private final static String jGroupsFlushNotPresentInStack = "FLUSH is not present in your JGroups stack!  FLUSH is needed to ensure messages are not dropped while new nodes join the cluster.  Will proceed, but inconsistencies may arise!";
    private final static String recommendConfiguringLuceneVersion = "Configuration setting hibernate.search.lucene_version was not specified, using LUCENE_CURRENT.";
    private final static String targetedFieldNotSpatial = "The field used for the spatial query is not using SpatialFieldBridge: %1$s.%2$s";
    private final static String nullIsInvalidIndexedType = "'null' is not a valid indexed type";
    private final static String initializedBlackholeBackend = "initialized \"blackhole\" backend. Index changes will be prepared but discarded!";
    private final static String noCurrentMarkerInSourceDirectory = "No current marker in source directory. Has the master being started already?";
    private final static String indexManagerAliasResolved = "IndexManager factory resolved alias '%1$s' to '%2$s'.";
    private final static String unableToReadTokenStream = "Unable to read TokenStream";
    private final static String terminatingBatchWorkCanCauseInconsistentState = "Terminating batch work! Index might end up in inconsistent state.";
    private final static String unableToInstantiateFieldBridge = "Unable to instantiate FieldBridge for %1$s of class %2$s";
    private final static String cannotHaveTwoSpatialsWithDefaultOrSameName = "Class %1$s cannot have two @Spatial using default/same name";
    private final static String unknownFullTextFilter = "Unknown @FullTextFilter: '%1$s'";
    private final static String readerProviderExceptionOnDestroy = "ReaderProvider raises an exception on destroy()";
    private final static String unableToShutdownAsynchronousIndexingByTimeout = "Timed out waiting to flush all operations to the backend of index %1$s";
    private final static String missingJGroupsMuxId = "Configured JGroups channel is a Muxer! MuxId option is required: define 'hibernate.search.services.jgroups.mux_id'.";
    private final static String updatedDirectoryProviders = "update DirectoryProviders \"blackhole\" backend. Index changes will be prepared but discarded!";
    private final static String unableToConvertSerializableStoreToLuceneStore = "Unable to convert serializable Store to Lucene Store: %1$s";
    private final static String unableToLoadResource = "Could not load resource: '%1$s'";
    private final static String receivedEmptyLuceneWorksInMessage = "Received null or empty Lucene works list in message.";
    private final static String cannotOpenIndexWriterCausePreviousError = "Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!";
    private final static String unableToCloseSearcherInScrollableResult = "Unable to properly close searcher in ScrollableResults";
    private final static String jGroupsDisconnectingAndClosingChannel = "Disconnecting and closing JGroups Channel to cluster '%1$s'";
    private final static String noImplementationClassInFieldBridge = "@FieldBridge with no implementation class defined in: %1$s";
    private final static String unableToConvertSerializableIndexToLuceneIndex = "Unable to convert serializable Index to Lucene Index: %1$s";
    private final static String duplicateDocumentIdFound = "More than one @DocumentId specified on entity '%1$s'";
    private final static String forcingReleaseIndexWriterLock = "Going to force release of the IndexWriter lock";
    private final static String cannotDeserializeOperation = "Cannot deserialize operation %1$s, unknown operation.";
    private final static String idCannotBeExtracted = "Unable to reindex entity on collection change, id cannot be extracted: %1$s";
    private final static String indexManagerUsesSerializationService = "Serialization service %2$s being used for index '%1$s'";
    private final static String indexingEntitiesCompleted = "Reindexed %1$d entities";
    private final static String jGroupsDefaultConfigurationFileNotFound = "Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!";
    private final static String jGroupsChannelCreationFromStringError = "Error while trying to create a channel using config string: %1$s";
    private final static String ambiguousLongitudeDefinition = "@Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private final static String interruptedWhileWaitingForIndexActivity = "Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private final static String unableToSerializeLuceneWorks = "Unable to serialize List<LuceneWork>";
    private final static String pushedChangesOutOfTransaction = "It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!";
    private final static String unableToRemovePreviousMarket = "Unable to remove previous marker file from source of %1$s";
    private final static String unableToShutdownAsynchronousIndexing = "Unable to properly shut down asynchronous indexing work";
    private final static String unableToCloseLuceneIndexReader = "Unable to close Lucene IndexReader";
    private final static String version = "Hibernate Search %1$s";
    private final static String unableToCloseSearcherDuringQuery = "Unable to properly close searcher during lucene query: %1$s";
    private final static String unknownNumericFieldType = "Unknown NumericField type: %1$s";
    private final static String fileIsNotReadable = "File %1$s is not readable";
    private final static String unableToSendJMSWork = "Unable to send Search work to JMS queue '%2$s' for index '%1$s'";
    private final static String attributeNotRecognizedNorSerializable = "Attribute type is not recognized and not serializable: %1$s";
    private final static String ioExceptionOnIndexWriter = "IOException on the IndexWriter";
    private final static String notDeleted = "Could not delete %1$s";
    private final static String nullIsInvalidIndexName = "'null' is not a valid index name";
    private final static String unknownArrayBridgeForResolution = "Unknown ArrayBridge for resolution: %1$s";
    private final static String unableToCloseJmsConnection = "Unable to close JMS connection for %1$s";
    private final static String foundCurrentMarker = "Found current marker in source directory - initialization succeeded";
    private final static String unableToGetInputStreamFromBlob = "Unable to get input stream from blob data";
    private final static String containedInPointsToProvidedId = "@ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ";
    private final static String unableToUnregisterExistingMBean = "Unable to un-register existing MBean: %1$s";
    private final static String incorrectMessageType = "Incorrect message type: %1$s";
    private final static String interruptedWorkError = "Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private final static String unknownResolution = "Unknown Resolution: %1$s";
    private final static String eventListenerWontBeRegistered = "Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.";
    private final static String ambiguousLatitudeDefinition = "@Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private final static String cannotDeserializeField = "Cannot deserialize field type %1$s, unknown field type.";
    private final static String unableToSerializeInAvro = "Unable to serialize Lucene works in Avro";
    private final static String fileDoesNotExist = "File %1$s does not exist";
    private final static String unableToReadFile = "Unable to read file %1$s";
    private final static String fieldLooksBinaryButDecompressionFailed = "Field %1$s looks like binary but couldn't be decompressed";
    private final static String ioExceptionOnIndex = "An IOException happened while accessing the Lucene index '%1$s'";
    private final static String jGroupsStartingChannel = "Starting JGroups Channel";
    private final static String unableToOpenJMSConnection = "Unable to open JMS connection on queue '%2$s' for index '%1$s'";
    private final static String cannotGetResultSizeWithCriteriaAndRestriction = "Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s";
    private final static String couldNotCloseResource = "Could not close resource.";
    private final static String failToSerializeObject = "Fail to serialize object of type %1$s";
    private final static String unableToDetermineCurrentInSourceDirectory = "Unable to determine current in source directory, will try again during the next synchronization";
    private final static String jGroupsMuxIdAlreadyTaken = "MuxId '%1$d' configured on the JGroups was already taken. Can't register handler!";
    private final static String serviceProviderNotReleased = "Service provider has been used but not released: %1$s";
    private final static String backendError = "Error in backend";
    private final static String exceptionOccurred = "%1$s";
    private final static String illegalServiceBuildPhase = "Illegal state for service initialization";
    private final static String unableToRetrieveNamedAnalyzer = "Unable to retrieve named analyzer: %1$s";
    private final static String jGroupsConfigurationNotFoundInProperties = "Unable to use any JGroups configuration mechanisms provided in properties %1$s. Using default JGroups configuration file!";
    private final static String serializationProtocol = "Serialization protocol version %1$d.%2$d initialized";
    private final static String unableToSendWorkViaJGroups = "Unable to send Lucene update work via JGroups cluster";
    private final static String jGroupsChannelInjectionError = "Object injected for JGroups channel in hibernate.search.services.jgroups.providedChannel is of an unexpected type %1$s (expecting org.jgroups.JChannel)";
    private final static String unableConnectingToJGroupsCluster = "Unable to connect to: [%1$s] JGroups channel";
    private final static String indexingEntities = "Going to reindex %d entities";
    private final static String notChangeTimestamp = "Could not change timestamp for %1$s. Index synchronization may be slow.";
    private final static String unableToCloseLuceneDirectory = "Unable to properly close Lucene directory %1$s";
    private final static String errorDuringBatchIndexing = "Error during batch indexing: ";
    private final static String fieldBridgeNotAnInstanceof = "FieldBridge passed in is not an instance of %1$s";
    private final static String skippingDirectorySynchronization = "Skipping directory synchronization, previous work still in progress: %1$s";
    private final static String needAtLeastOneIndexName = "At least one index name must be provided: can't open an IndexReader on nothing";
    private final static String unableToStartJGroupsChannel = "Unable to start JGroups channel";
    private final static String interruptedBatchIndexing = "Batch indexing was interrupted";
    private final static String messageReceivedForUndefinedIndex = "Received a remote message about an unknown index '%1$s': discarding message!";
    private final static String incompatibleProtocolVersion = "Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d";
    private final static String massIndexerIndexWriterThreadsIgnored = "The option 'threadsForIndexWriter' of the MassIndexer is deprecated and is being ignored! Control the size of worker.thread_pool.size for each index instead.";
    private final static String stopServiceFailed = "Fail to properly stop service: %1$s";
    private final static String cannotSerializeCustomField = "Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.";
    private final static String unableToCreateCurrentMarker = "Unable to create current marker in source of %1$s";
    private final static String unknownMapBridgeForResolution = "Unknown MapBridge for resolution: %1$s";
    private final static String unableToInitializeIndexManager = "Unable to initialize IndexManager %1$s";
    private final static String forceUpdateOnIndexOperationViaInterception = "Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s";
    private final static String notAnIndexedType = "%1$s is not an indexed type";
    private final static String illegalObjectRetrievedFromMessage = "Illegal object retrieved from message";
    private final static String unableToCompareSourceWithDestinationDirectory = "Unable to compare %1$s with %2$s.";
    private final static String jGroupsChannelCreationUsingFileError = "Error while trying to create a channel using config file: %1$s";
    private final static String jGroupsConnectedToCluster = "Connected to cluster [ %1$s ]. The node address is %2$s";
    private final static String warnSuspiciousBackendDirectoryCombination = "The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations";
    private final static String conversionFromReaderToStringNotYetImplemented = "Conversion from Reader to String not yet implemented";
    private final static String fileIsADirectory = "%1$s is a directory and not a file";
    private final static String optimizationSkippedStillBusy = "Skipping optimization on index %1$s as it is already being optimized";
    private final static String forceSkipIndexOperationViaInterception = "Interceptor enforces skip index operation %2$s on instance of class %1$s";
    private final static String directoryProviderExceptionOnStop = "DirectoryProvider raises an exception on stop() ";
    private final static String indexingSpeed = "Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private final static String unableToStartSerializationLayer = "Unable to start serialization layer";
    private final static String legacyJGroupsConfigurationDefined = "JGroups channel configuration should be specified in the global section [hibernate.search.services.jgroups.], not as an IndexManager property for index '%1$s'. See http://docs.jboss.org/hibernate/search/4.1/reference/en-US/html_single/#jgroups-backend";
    private final static String unsupportedTikaBridgeType = "Unable to get input stream from blob data";
    private final static String ignoringBackendOptionForIndex = "Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.";
    private final static String noFieldBridgeInterfaceImplementedByClassBridge = "@ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge";
    private final static String queryWithNoTermsAfterAnalysis = "The query string '%2$s' applied on field '%1$s' has no meaningfull tokens to be matched. Validate the query input against the Analyzer applied on this field.";
    private final static String jGroupsClosingChannelError = "Problem closing channel; setting it to null";
    private final static String closedBlackholeBackend = "closed \"blackhole\" backend.";
    private final static String unableToDetermineClassBridge = "Unable to determine ClassBridge for %1$s";
    private final static String cannotReadFieldForClass = "Cannot read %1$s field from a %2$s object : does getter exists and is it public ?";
    private final static String readersNotProperlyClosedInReaderProvider = "ReaderProvider contains readers not properly closed at destroy time";
    private final static String unableToInstantiateSpatial = "Unable to instantiate Spatial defined on %1$s";
    private final static String indexDirectoryNotFoundCreatingNewOne = "Index directory not found, creating: '%1$s'";
    private final static String unableToSynchronizeSource = "Unable to synchronize source of %1$s";
    private final static String errorExecutingRunnableInTransaction = "Error while executing runnable wrapped in a JTA transaction";
    private final static String unknownAttributeSerializedRepresentation = "Unknown attribute serialized representation: %1$s";
    private final static String forceToUseDocumentExtraction = "Forced to use Document extraction to workaround FieldCache bug in Lucene";
    private final static String cannotExtractValueForIdentifier = "FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled";
    private final static String unknownIterableBridgeForResolution = "Unknown IterableBridge for resolution: %1$s";
    private final static String errorRollingBackTransaction = "Error while rolling back transaction after %1$s";
    private final static String forceRemoveOnIndexOperationViaInterception = "Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s";
    private final static String jGroupsChannelCreationUsingXmlError = "Error while trying to create a channel using config XML: %1$s";
    private final static String checkSizeMustBePositive = "Chunk size must be positive: using default value.";
    private final static String unableToGuessFieldBridge = "Unable to guess FieldBridge for %2$s in %1$s";
    private final static String cannotInstantiateClassBridgeOfType = "Unable to instantiate ClassBridge of type %1$s defined on %2$s";
    private final static String abstractClassesCannotInsertDocuments = "Abstract classes can never insert index documents. Remove @Indexed.";
    private final static String similarityInstantiationException = "Exception attempting to instantiate Similarity '%1$s' set for %2$s";
    private final static String jmsLookupException = "Unable to lookup Search queue '%1$s' and connection factory '%2$s' for index '%3$s'";

    public Log_$logger(final Logger log) {
        super(log);
    }

    public final org.hibernate.search.SearchException unableToDeserializeAvroStream(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000099: ")+ unableToDeserializeAvroStream$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeserializeAvroStream$str() {
        return unableToDeserializeAvroStream;
    }

    public final org.hibernate.search.SearchException noFieldBridgeInterfaceImplementedByFieldBridge(final String implName, final String appliedOnName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000138: ")+ noFieldBridgeInterfaceImplementedByFieldBridge$str()), implName, appliedOnName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByFieldBridge$str() {
        return noFieldBridgeInterfaceImplementedByFieldBridge;
    }

    public final org.hibernate.search.SearchException requestedIndexNotDefined(final String indexName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000107: ")+ requestedIndexNotDefined$str()), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestedIndexNotDefined$str() {
        return requestedIndexNotDefined;
    }

    public final void unexpectedErrorInLuceneBackend(final Throwable tw) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (tw), ((projectCode +"000074: ")+ unexpectedErrorInLuceneBackend$str()));
    }

    protected String unexpectedErrorInLuceneBackend$str() {
        return unexpectedErrorInLuceneBackend;
    }

    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000030: ")+ indexingDocumentsCompleted$str()), doneCount, elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    public final void shuttingDownBackend(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.DEBUG), null, ((projectCode +"000108: ")+ shuttingDownBackend$str()), indexName);
    }

    protected String shuttingDownBackend$str() {
        return shuttingDownBackend;
    }

    public final void cannotGuessTransactionStatus(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000036: ")+ cannotGuessTransactionStatus$str()));
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    public final org.hibernate.search.SearchException unableToConvertSerializableTermVectorToLuceneTermVector(final String termVector) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000088: ")+ unableToConvertSerializableTermVectorToLuceneTermVector$str()), termVector));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableTermVectorToLuceneTermVector$str() {
        return unableToConvertSerializableTermVectorToLuceneTermVector;
    }

    public final IllegalArgumentException needAtLeastOneIndexedEntityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000112: ")+ needAtLeastOneIndexedEntityType$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexedEntityType$str() {
        return needAtLeastOneIndexedEntityType;
    }

    public final void workerException(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000059: ")+ workerException$str()));
    }

    protected String workerException$str() {
        return workerException;
    }

    public final org.hibernate.search.SearchException cannotExtractCoordinateFromObject(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000157: ")+ cannotExtractCoordinateFromObject$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractCoordinateFromObject$str() {
        return cannotExtractCoordinateFromObject;
    }

    public final org.hibernate.search.SearchException failToDeserializeObject(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000096: ")+ failToDeserializeObject$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToDeserializeObject$str() {
        return failToDeserializeObject;
    }

    public final String exceptionDuringIndexMergeOperation() {
        String result = String.format(((projectCode +"000118: ")+ exceptionDuringIndexMergeOperation$str()));
        return result;
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    public final org.hibernate.search.SearchException spatialFieldNameNotDefined(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000145: ")+ spatialFieldNameNotDefined$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spatialFieldNameNotDefined$str() {
        return spatialFieldNameNotDefined;
    }

    public final void unableToRetrieveObjectFromMessage(final Class messageClass, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000068: ")+ unableToRetrieveObjectFromMessage$str()), messageClass);
    }

    protected String unableToRetrieveObjectFromMessage$str() {
        return unableToRetrieveObjectFromMessage;
    }

    public final org.hibernate.search.SearchException unableToConfigureTikaBridge(final String bridgeName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000155: ")+ unableToConfigureTikaBridge$str()), bridgeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureTikaBridge$str() {
        return unableToConfigureTikaBridge;
    }

    public final org.hibernate.search.SearchException cannotFindCoordinatesNorLatLongForSpatial(final String spatialName, final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000159: ")+ cannotFindCoordinatesNorLatLongForSpatial$str()), spatialName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindCoordinatesNorLatLongForSpatial$str() {
        return cannotFindCoordinatesNorLatLongForSpatial;
    }

    public final void indexingCompletedAndMBeanUnregistered(final long nbrOfEntities) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000029: ")+ indexingCompletedAndMBeanUnregistered$str()), nbrOfEntities);
    }

    protected String indexingCompletedAndMBeanUnregistered$str() {
        return indexingCompletedAndMBeanUnregistered;
    }

    public final org.hibernate.search.SearchException fieldBridgeNotTwoWay(final Class bridgeClass, final String fieldName, final XClass beanXClass) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000169: ")+ fieldBridgeNotTwoWay$str()), bridgeClass, fieldName, beanXClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotTwoWay$str() {
        return fieldBridgeNotTwoWay;
    }

    public final String massIndexerUnexpectedErrorMessage() {
        String result = String.format(((projectCode +"000116: ")+ massIndexerUnexpectedErrorMessage$str()));
        return result;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    public final org.hibernate.search.SearchException unableToReadSerializedLuceneWorks(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000084: ")+ unableToReadSerializedLuceneWorks$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadSerializedLuceneWorks$str() {
        return unableToReadSerializedLuceneWorks;
    }

    public final org.hibernate.search.SearchException cantOpenCorruptedIndex(final CorruptIndexException e, final String indexName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000076: ")+ cantOpenCorruptedIndex$str()), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantOpenCorruptedIndex$str() {
        return cantOpenCorruptedIndex;
    }

    public final void inconsistentFieldConfiguration(final String fieldName) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000120: ")+ inconsistentFieldConfiguration$str()), fieldName);
    }

    protected String inconsistentFieldConfiguration$str() {
        return inconsistentFieldConfiguration;
    }

    public final void jGroupsReceivedNewClusterView(final Object view) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000015: ")+ jGroupsReceivedNewClusterView$str()), view);
    }

    protected String jGroupsReceivedNewClusterView$str() {
        return jGroupsReceivedNewClusterView;
    }

    public final void unexpectedValueMissingFromFieldCache() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000040: ")+ unexpectedValueMissingFromFieldCache$str()));
    }

    protected String unexpectedValueMissingFromFieldCache$str() {
        return unexpectedValueMissingFromFieldCache;
    }

    public final void failedSlaveDirectoryProviderInitialization(final String indexName, final Exception re) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (re), ((projectCode +"000066: ")+ failedSlaveDirectoryProviderInitialization$str()), indexName);
    }

    protected String failedSlaveDirectoryProviderInitialization$str() {
        return failedSlaveDirectoryProviderInitialization;
    }

    public final org.hibernate.search.SearchException unknownFieldType(final Class fieldType) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000093: ")+ unknownFieldType$str()), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldType$str() {
        return unknownFieldType;
    }

    public final void jGroupsFlushNotPresentInStack() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000007: ")+ jGroupsFlushNotPresentInStack$str()));
    }

    protected String jGroupsFlushNotPresentInStack$str() {
        return jGroupsFlushNotPresentInStack;
    }

    public final void recommendConfiguringLuceneVersion() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000075: ")+ recommendConfiguringLuceneVersion$str()));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    public final org.hibernate.search.SearchException targetedFieldNotSpatial(final String className, final String fieldName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000131: ")+ targetedFieldNotSpatial$str()), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedFieldNotSpatial$str() {
        return targetedFieldNotSpatial;
    }

    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000110: ")+ nullIsInvalidIndexedType$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexedType$str() {
        return nullIsInvalidIndexedType;
    }

    public final void initializedBlackholeBackend() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000001: ")+ initializedBlackholeBackend$str()));
    }

    protected String initializedBlackholeBackend$str() {
        return initializedBlackholeBackend;
    }

    public final void noCurrentMarkerInSourceDirectory() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000042: ")+ noCurrentMarkerInSourceDirectory$str()));
    }

    protected String noCurrentMarkerInSourceDirectory$str() {
        return noCurrentMarkerInSourceDirectory;
    }

    public final void indexManagerAliasResolved(final String alias, final Class im) {
        super.log.logf(FQCN, (Logger.Level.DEBUG), null, ((projectCode +"000166: ")+ indexManagerAliasResolved$str()), alias, im);
    }

    protected String indexManagerAliasResolved$str() {
        return indexManagerAliasResolved;
    }

    public final org.hibernate.search.SearchException unableToReadTokenStream() {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000087: ")+ unableToReadTokenStream$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadTokenStream$str() {
        return unableToReadTokenStream;
    }

    public final void terminatingBatchWorkCanCauseInconsistentState() {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000070: ")+ terminatingBatchWorkCanCauseInconsistentState$str()));
    }

    protected String terminatingBatchWorkCanCauseInconsistentState$str() {
        return terminatingBatchWorkCanCauseInconsistentState;
    }

    public final org.hibernate.search.SearchException unableToInstantiateFieldBridge(final String appliedOnName, final String appliedOnTypeName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000139: ")+ unableToInstantiateFieldBridge$str()), appliedOnName, appliedOnTypeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateFieldBridge$str() {
        return unableToInstantiateFieldBridge;
    }

    public final org.hibernate.search.SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000158: ")+ cannotHaveTwoSpatialsWithDefaultOrSameName$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotHaveTwoSpatialsWithDefaultOrSameName$str() {
        return cannotHaveTwoSpatialsWithDefaultOrSameName;
    }

    public final org.hibernate.search.SearchException unknownFullTextFilter(final String filterName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000115: ")+ unknownFullTextFilter$str()), filterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFullTextFilter$str() {
        return unknownFullTextFilter;
    }

    public final void readerProviderExceptionOnDestroy(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000060: ")+ readerProviderExceptionOnDestroy$str()));
    }

    protected String readerProviderExceptionOnDestroy$str() {
        return readerProviderExceptionOnDestroy;
    }

    public final void unableToShutdownAsynchronousIndexingByTimeout(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000078: ")+ unableToShutdownAsynchronousIndexingByTimeout$str()), indexName);
    }

    protected String unableToShutdownAsynchronousIndexingByTimeout$str() {
        return unableToShutdownAsynchronousIndexingByTimeout;
    }

    public final org.hibernate.search.SearchException missingJGroupsMuxId() {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000147: ")+ missingJGroupsMuxId$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingJGroupsMuxId$str() {
        return missingJGroupsMuxId;
    }

    public final void updatedDirectoryProviders() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000003: ")+ updatedDirectoryProviders$str()));
    }

    protected String updatedDirectoryProviders$str() {
        return updatedDirectoryProviders;
    }

    public final org.hibernate.search.SearchException unableToConvertSerializableStoreToLuceneStore(final String store) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000090: ")+ unableToConvertSerializableStoreToLuceneStore$str()), store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableStoreToLuceneStore$str() {
        return unableToConvertSerializableStoreToLuceneStore;
    }

    public final org.hibernate.search.SearchException unableToLoadResource(final String fileName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000114: ")+ unableToLoadResource$str()), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    public final void receivedEmptyLuceneWorksInMessage() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000051: ")+ receivedEmptyLuceneWorksInMessage$str()));
    }

    protected String receivedEmptyLuceneWorksInMessage$str() {
        return receivedEmptyLuceneWorksInMessage;
    }

    public final void cannotOpenIndexWriterCausePreviousError() {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000072: ")+ cannotOpenIndexWriterCausePreviousError$str()));
    }

    protected String cannotOpenIndexWriterCausePreviousError$str() {
        return cannotOpenIndexWriterCausePreviousError;
    }

    public final void unableToCloseSearcherInScrollableResult(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000039: ")+ unableToCloseSearcherInScrollableResult$str()));
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return unableToCloseSearcherInScrollableResult;
    }

    public final void jGroupsDisconnectingAndClosingChannel(final String clusterName) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000013: ")+ jGroupsDisconnectingAndClosingChannel$str()), clusterName);
    }

    protected String jGroupsDisconnectingAndClosingChannel$str() {
        return jGroupsDisconnectingAndClosingChannel;
    }

    public final org.hibernate.search.SearchException noImplementationClassInFieldBridge(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000137: ")+ noImplementationClassInFieldBridge$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noImplementationClassInFieldBridge$str() {
        return noImplementationClassInFieldBridge;
    }

    public final org.hibernate.search.SearchException unableToConvertSerializableIndexToLuceneIndex(final String index) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000089: ")+ unableToConvertSerializableIndexToLuceneIndex$str()), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableIndexToLuceneIndex$str() {
        return unableToConvertSerializableIndexToLuceneIndex;
    }

    public final org.hibernate.search.SearchException duplicateDocumentIdFound(final String beanXClassName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000167: ")+ duplicateDocumentIdFound$str()), beanXClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateDocumentIdFound$str() {
        return duplicateDocumentIdFound;
    }

    public final void forcingReleaseIndexWriterLock() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000052: ")+ forcingReleaseIndexWriterLock$str()));
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    public final org.hibernate.search.SearchException cannotDeserializeOperation(final String schema) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000100: ")+ cannotDeserializeOperation$str()), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeOperation$str() {
        return cannotDeserializeOperation;
    }

    public final void idCannotBeExtracted(final String affectedOwnerEntityName) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000024: ")+ idCannotBeExtracted$str()), affectedOwnerEntityName);
    }

    protected String idCannotBeExtracted$str() {
        return idCannotBeExtracted;
    }

    public final void indexManagerUsesSerializationService(final String indexName, final String serializerDescription) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000168: ")+ indexManagerUsesSerializationService$str()), indexName, serializerDescription);
    }

    protected String indexManagerUsesSerializationService$str() {
        return indexManagerUsesSerializationService;
    }

    public final void indexingEntitiesCompleted(final long nbrOfEntities) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000028: ")+ indexingEntitiesCompleted$str()), nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    public final void jGroupsDefaultConfigurationFileNotFound() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000012: ")+ jGroupsDefaultConfigurationFileNotFound$str()));
    }

    protected String jGroupsDefaultConfigurationFileNotFound$str() {
        return jGroupsDefaultConfigurationFileNotFound;
    }

    public final org.hibernate.search.SearchException jGroupsChannelCreationFromStringError(final String configuration, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000010: ")+ jGroupsChannelCreationFromStringError$str()), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationFromStringError$str() {
        return jGroupsChannelCreationFromStringError;
    }

    public final org.hibernate.search.SearchException ambiguousLongitudeDefinition(final String beanXClassName, final String firstField, final String secondField) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000161: ")+ ambiguousLongitudeDefinition$str()), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLongitudeDefinition$str() {
        return ambiguousLongitudeDefinition;
    }

    public final void interruptedWhileWaitingForIndexActivity(final InterruptedException e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000049: ")+ interruptedWhileWaitingForIndexActivity$str()));
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    public final org.hibernate.search.SearchException unableToSerializeLuceneWorks(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000083: ")+ unableToSerializeLuceneWorks$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeLuceneWorks$str() {
        return unableToSerializeLuceneWorks;
    }

    public final void pushedChangesOutOfTransaction() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000050: ")+ pushedChangesOutOfTransaction$str()));
    }

    protected String pushedChangesOutOfTransaction$str() {
        return pushedChangesOutOfTransaction;
    }

    public final void unableToRemovePreviousMarket(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000019: ")+ unableToRemovePreviousMarket$str()), indexName);
    }

    protected String unableToRemovePreviousMarket$str() {
        return unableToRemovePreviousMarket;
    }

    public final void unableToShutdownAsynchronousIndexing(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000071: ")+ unableToShutdownAsynchronousIndexing$str()));
    }

    protected String unableToShutdownAsynchronousIndexing$str() {
        return unableToShutdownAsynchronousIndexing;
    }

    public final void unableToCloseLuceneIndexReader(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000055: ")+ unableToCloseLuceneIndexReader$str()));
    }

    protected String unableToCloseLuceneIndexReader$str() {
        return unableToCloseLuceneIndexReader;
    }

    public final void version(final String versionString) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000034: ")+ version$str()), versionString);
    }

    protected String version$str() {
        return version;
    }

    public final void unableToCloseSearcherDuringQuery(final String query, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000037: ")+ unableToCloseSearcherDuringQuery$str()), query);
    }

    protected String unableToCloseSearcherDuringQuery$str() {
        return unableToCloseSearcherDuringQuery;
    }

    public final org.hibernate.search.SearchException unknownNumericFieldType(final String dataType) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000091: ")+ unknownNumericFieldType$str()), dataType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNumericFieldType$str() {
        return unknownNumericFieldType;
    }

    public final org.hibernate.search.SearchException fileIsNotReadable(final String fileName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000154: ")+ fileIsNotReadable$str()), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }

    public final org.hibernate.search.SearchException unableToSendJMSWork(final String indexName, final String jmsQueueName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000163: ")+ unableToSendJMSWork$str()), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendJMSWork$str() {
        return unableToSendJMSWork;
    }

    public final org.hibernate.search.SearchException attributeNotRecognizedNorSerializable(final Class attributeType) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000085: ")+ attributeNotRecognizedNorSerializable$str()), attributeType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeNotRecognizedNorSerializable$str() {
        return attributeNotRecognizedNorSerializable;
    }

    public final String ioExceptionOnIndexWriter() {
        String result = String.format(((projectCode +"000117: ")+ ioExceptionOnIndexWriter$str()));
        return result;
    }

    protected String ioExceptionOnIndexWriter$str() {
        return ioExceptionOnIndexWriter;
    }

    public final void notDeleted(final File file) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000032: ")+ notDeleted$str()), file);
    }

    protected String notDeleted$str() {
        return notDeleted;
    }

    public final IllegalArgumentException nullIsInvalidIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000113: ")+ nullIsInvalidIndexName$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexName$str() {
        return nullIsInvalidIndexName;
    }

    public final org.hibernate.annotations.common.AssertionFailure unknownArrayBridgeForResolution(final String resolution) {
        org.hibernate.annotations.common.AssertionFailure result = new org.hibernate.annotations.common.AssertionFailure(String.format(((projectCode +"000141: ")+ unknownArrayBridgeForResolution$str()), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownArrayBridgeForResolution$str() {
        return unknownArrayBridgeForResolution;
    }

    public final void unableToCloseJmsConnection(final String jmsQueueName, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000047: ")+ unableToCloseJmsConnection$str()), jmsQueueName);
    }

    protected String unableToCloseJmsConnection$str() {
        return unableToCloseJmsConnection;
    }

    public final void foundCurrentMarker() {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000043: ")+ foundCurrentMarker$str()));
    }

    protected String foundCurrentMarker$str() {
        return foundCurrentMarker;
    }

    public final org.hibernate.search.SearchException unableToGetInputStreamFromBlob(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000150: ")+ unableToGetInputStreamFromBlob$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetInputStreamFromBlob$str() {
        return unableToGetInputStreamFromBlob;
    }

    public final void containedInPointsToProvidedId(final Class objectClass) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000045: ")+ containedInPointsToProvidedId$str()), objectClass);
    }

    protected String containedInPointsToProvidedId$str() {
        return containedInPointsToProvidedId;
    }

    public final void unableToUnregisterExistingMBean(final String name, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000056: ")+ unableToUnregisterExistingMBean$str()), name);
    }

    protected String unableToUnregisterExistingMBean$str() {
        return unableToUnregisterExistingMBean;
    }

    public final void incorrectMessageType(final Class messageType) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000016: ")+ incorrectMessageType$str()), messageType);
    }

    protected String incorrectMessageType$str() {
        return incorrectMessageType;
    }

    public final void interruptedWorkError(final Runnable r) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000017: ")+ interruptedWorkError$str()), r);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    public final org.hibernate.annotations.common.AssertionFailure unknownResolution(final String resolution) {
        org.hibernate.annotations.common.AssertionFailure result = new org.hibernate.annotations.common.AssertionFailure(String.format(((projectCode +"000140: ")+ unknownResolution$str()), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    public final void eventListenerWontBeRegistered() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000057: ")+ eventListenerWontBeRegistered$str()));
    }

    protected String eventListenerWontBeRegistered$str() {
        return eventListenerWontBeRegistered;
    }

    public final org.hibernate.search.SearchException ambiguousLatitudeDefinition(final String beanXClassName, final String firstField, final String secondField) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000160: ")+ ambiguousLatitudeDefinition$str()), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLatitudeDefinition$str() {
        return ambiguousLatitudeDefinition;
    }

    public final org.hibernate.search.SearchException cannotDeserializeField(final String schema) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000101: ")+ cannotDeserializeField$str()), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeField$str() {
        return cannotDeserializeField;
    }

    public final org.hibernate.search.SearchException unableToSerializeInAvro(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000102: ")+ unableToSerializeInAvro$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeInAvro$str() {
        return unableToSerializeInAvro;
    }

    public final org.hibernate.search.SearchException fileDoesNotExist(final String fileName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000152: ")+ fileDoesNotExist$str()), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }

    public final org.hibernate.search.SearchException unableToReadFile(final String filename, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000097: ")+ unableToReadFile$str()), filename), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadFile$str() {
        return unableToReadFile;
    }

    public final org.hibernate.search.SearchException fieldLooksBinaryButDecompressionFailed(final String fieldName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000106: ")+ fieldLooksBinaryButDecompressionFailed$str()), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldLooksBinaryButDecompressionFailed$str() {
        return fieldLooksBinaryButDecompressionFailed;
    }

    public final org.hibernate.search.SearchException ioExceptionOnIndex(final IOException e, final String indexName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000077: ")+ ioExceptionOnIndex$str()), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndex$str() {
        return ioExceptionOnIndex;
    }

    public final void jGroupsStartingChannel() {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000005: ")+ jGroupsStartingChannel$str()));
    }

    protected String jGroupsStartingChannel$str() {
        return jGroupsStartingChannel;
    }

    public final org.hibernate.search.SearchException unableToOpenJMSConnection(final String indexName, final String jmsQueueName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000162: ")+ unableToOpenJMSConnection$str()), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOpenJMSConnection$str() {
        return unableToOpenJMSConnection;
    }

    public final org.hibernate.search.SearchException cannotGetResultSizeWithCriteriaAndRestriction(final String criteria) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000105: ")+ cannotGetResultSizeWithCriteriaAndRestriction$str()), criteria));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetResultSizeWithCriteriaAndRestriction$str() {
        return cannotGetResultSizeWithCriteriaAndRestriction;
    }

    public final void couldNotCloseResource(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000035: ")+ couldNotCloseResource$str()));
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    public final org.hibernate.search.SearchException failToSerializeObject(final Class type, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000095: ")+ failToSerializeObject$str()), type), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToSerializeObject$str() {
        return failToSerializeObject;
    }

    public final void unableToDetermineCurrentInSourceDirectory() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000022: ")+ unableToDetermineCurrentInSourceDirectory$str()));
    }

    protected String unableToDetermineCurrentInSourceDirectory$str() {
        return unableToDetermineCurrentInSourceDirectory;
    }

    public final org.hibernate.search.SearchException jGroupsMuxIdAlreadyTaken(final short n) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000148: ")+ jGroupsMuxIdAlreadyTaken$str()), n));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsMuxIdAlreadyTaken$str() {
        return jGroupsMuxIdAlreadyTaken;
    }

    public final void serviceProviderNotReleased(final Class class1) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000025: ")+ serviceProviderNotReleased$str()), class1);
    }

    protected String serviceProviderNotReleased$str() {
        return serviceProviderNotReleased;
    }

    public final void backendError(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000073: ")+ backendError$str()));
    }

    protected String backendError$str() {
        return backendError;
    }

    public final void exceptionOccurred(final String errorMsg, final Throwable exceptionThatOccurred) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (exceptionThatOccurred), ((projectCode +"000058: ")+ exceptionOccurred$str()), errorMsg);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    public final org.hibernate.search.SearchException illegalServiceBuildPhase() {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000165: ")+ illegalServiceBuildPhase$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalServiceBuildPhase$str() {
        return illegalServiceBuildPhase;
    }

    public final void unableToRetrieveNamedAnalyzer(final String value) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000048: ")+ unableToRetrieveNamedAnalyzer$str()), value);
    }

    protected String unableToRetrieveNamedAnalyzer$str() {
        return unableToRetrieveNamedAnalyzer;
    }

    public final void jGroupsConfigurationNotFoundInProperties(final Properties props) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000011: ")+ jGroupsConfigurationNotFoundInProperties$str()), props);
    }

    protected String jGroupsConfigurationNotFoundInProperties$str() {
        return jGroupsConfigurationNotFoundInProperties;
    }

    public final void serializationProtocol(final int major, final int minor) {
        super.log.logf(FQCN, (Logger.Level.DEBUG), null, ((projectCode +"000079: ")+ serializationProtocol$str()), major, minor);
    }

    protected String serializationProtocol$str() {
        return serializationProtocol;
    }

    public final org.hibernate.search.SearchException unableToSendWorkViaJGroups(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000123: ")+ unableToSendWorkViaJGroups$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendWorkViaJGroups$str() {
        return unableToSendWorkViaJGroups;
    }

    public final org.hibernate.search.SearchException jGroupsChannelInjectionError(final Exception e, final Class actualType) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000129: ")+ jGroupsChannelInjectionError$str()), actualType), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelInjectionError$str() {
        return jGroupsChannelInjectionError;
    }

    public final org.hibernate.search.SearchException unableConnectingToJGroupsCluster(final String clusterName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000121: ")+ unableConnectingToJGroupsCluster$str()), clusterName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableConnectingToJGroupsCluster$str() {
        return unableConnectingToJGroupsCluster;
    }

    public final void indexingEntities(final long count) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000027: ")+ indexingEntities$str()), count);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    public final void notChangeTimestamp(final File destFile) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000033: ")+ notChangeTimestamp$str()), destFile);
    }

    protected String notChangeTimestamp$str() {
        return notChangeTimestamp;
    }

    public final void unableToCloseLuceneDirectory(final Object directory, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000067: ")+ unableToCloseLuceneDirectory$str()), directory);
    }

    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }

    public final void errorDuringBatchIndexing(final Throwable e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000063: ")+ errorDuringBatchIndexing$str()));
    }

    protected String errorDuringBatchIndexing$str() {
        return errorDuringBatchIndexing;
    }

    public final org.hibernate.search.SearchException fieldBridgeNotAnInstanceof(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000144: ")+ fieldBridgeNotAnInstanceof$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotAnInstanceof$str() {
        return fieldBridgeNotAnInstanceof;
    }

    public final void skippingDirectorySynchronization(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000018: ")+ skippingDirectorySynchronization$str()), indexName);
    }

    protected String skippingDirectorySynchronization$str() {
        return skippingDirectorySynchronization;
    }

    public final IllegalArgumentException needAtLeastOneIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000111: ")+ needAtLeastOneIndexName$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexName$str() {
        return needAtLeastOneIndexName;
    }

    public final org.hibernate.search.SearchException unableToStartJGroupsChannel(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000122: ")+ unableToStartJGroupsChannel$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartJGroupsChannel$str() {
        return unableToStartJGroupsChannel;
    }

    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000062: ")+ interruptedBatchIndexing$str()));
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    public final void messageReceivedForUndefinedIndex(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000080: ")+ messageReceivedForUndefinedIndex$str()), indexName);
    }

    protected String messageReceivedForUndefinedIndex$str() {
        return messageReceivedForUndefinedIndex;
    }

    public final org.hibernate.search.SearchException incompatibleProtocolVersion(final int messageMajor, final int messageMinor, final int currentMajor, final int currentMinor) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000098: ")+ incompatibleProtocolVersion$str()), messageMajor, messageMinor, currentMajor, currentMinor));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleProtocolVersion$str() {
        return incompatibleProtocolVersion;
    }

    public final void massIndexerIndexWriterThreadsIgnored() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000124: ")+ massIndexerIndexWriterThreadsIgnored$str()));
    }

    protected String massIndexerIndexWriterThreadsIgnored$str() {
        return massIndexerIndexWriterThreadsIgnored;
    }

    public final void stopServiceFailed(final Class class1, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000026: ")+ stopServiceFailed$str()), class1);
    }

    protected String stopServiceFailed$str() {
        return stopServiceFailed;
    }

    public final org.hibernate.search.SearchException cannotSerializeCustomField(final Class fieldType) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000094: ")+ cannotSerializeCustomField$str()), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSerializeCustomField$str() {
        return cannotSerializeCustomField;
    }

    public final void unableToCreateCurrentMarker(final String indexName, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.WARN), (e), ((projectCode +"000020: ")+ unableToCreateCurrentMarker$str()), indexName);
    }

    protected String unableToCreateCurrentMarker$str() {
        return unableToCreateCurrentMarker;
    }

    public final org.hibernate.annotations.common.AssertionFailure unknownMapBridgeForResolution(final String resolution) {
        org.hibernate.annotations.common.AssertionFailure result = new org.hibernate.annotations.common.AssertionFailure(String.format(((projectCode +"000142: ")+ unknownMapBridgeForResolution$str()), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownMapBridgeForResolution$str() {
        return unknownMapBridgeForResolution;
    }

    public final org.hibernate.search.SearchException unableToInitializeIndexManager(final String indexName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000103: ")+ unableToInitializeIndexManager$str()), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexManager$str() {
        return unableToInitializeIndexManager;
    }

    public final void forceUpdateOnIndexOperationViaInterception(final Class entityClass, final org.hibernate.search.backend.spi.WorkType type) {
        super.log.logf(FQCN, (Logger.Level.TRACE), null, ((projectCode +"000128: ")+ forceUpdateOnIndexOperationViaInterception$str()), entityClass, type);
    }

    protected String forceUpdateOnIndexOperationViaInterception$str() {
        return forceUpdateOnIndexOperationViaInterception;
    }

    public final IllegalArgumentException notAnIndexedType(final String entityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000109: ")+ notAnIndexedType$str()), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnIndexedType$str() {
        return notAnIndexedType;
    }

    public final void illegalObjectRetrievedFromMessage(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000069: ")+ illegalObjectRetrievedFromMessage$str()));
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    public final void unableToCompareSourceWithDestinationDirectory(final String source, final String destination) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000023: ")+ unableToCompareSourceWithDestinationDirectory$str()), source, destination);
    }

    protected String unableToCompareSourceWithDestinationDirectory$str() {
        return unableToCompareSourceWithDestinationDirectory;
    }

    public final org.hibernate.search.SearchException jGroupsChannelCreationUsingFileError(final String configuration, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000008: ")+ jGroupsChannelCreationUsingFileError$str()), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationUsingFileError$str() {
        return jGroupsChannelCreationUsingFileError;
    }

    public final void jGroupsConnectedToCluster(final String clusterName, final Object address) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000006: ")+ jGroupsConnectedToCluster$str()), clusterName, address);
    }

    protected String jGroupsConnectedToCluster$str() {
        return jGroupsConnectedToCluster;
    }

    public final void warnSuspiciousBackendDirectoryCombination(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000081: ")+ warnSuspiciousBackendDirectoryCombination$str()), indexName);
    }

    protected String warnSuspiciousBackendDirectoryCombination$str() {
        return warnSuspiciousBackendDirectoryCombination;
    }

    public final org.hibernate.search.SearchException conversionFromReaderToStringNotYetImplemented() {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000092: ")+ conversionFromReaderToStringNotYetImplemented$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conversionFromReaderToStringNotYetImplemented$str() {
        return conversionFromReaderToStringNotYetImplemented;
    }

    public final org.hibernate.search.SearchException fileIsADirectory(final String fileName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000153: ")+ fileIsADirectory$str()), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsADirectory$str() {
        return fileIsADirectory;
    }

    public final void optimizationSkippedStillBusy(final String indexName) {
        super.log.logf(FQCN, (Logger.Level.DEBUG), null, ((projectCode +"000119: ")+ optimizationSkippedStillBusy$str()), indexName);
    }

    protected String optimizationSkippedStillBusy$str() {
        return optimizationSkippedStillBusy;
    }

    public final void forceSkipIndexOperationViaInterception(final Class entityClass, final org.hibernate.search.backend.spi.WorkType type) {
        super.log.logf(FQCN, (Logger.Level.TRACE), null, ((projectCode +"000125: ")+ forceSkipIndexOperationViaInterception$str()), entityClass, type);
    }

    protected String forceSkipIndexOperationViaInterception$str() {
        return forceSkipIndexOperationViaInterception;
    }

    public final void directoryProviderExceptionOnStop(final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000061: ")+ directoryProviderExceptionOnStop$str()));
    }

    protected String directoryProviderExceptionOnStop$str() {
        return directoryProviderExceptionOnStop;
    }

    public final void indexingSpeed(final float estimateSpeed, final float estimatePercentileComplete) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000031: ")+ indexingSpeed$str()), estimateSpeed, estimatePercentileComplete);
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    public final org.hibernate.search.SearchException unableToStartSerializationLayer(final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000082: ")+ unableToStartSerializationLayer$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartSerializationLayer$str() {
        return unableToStartSerializationLayer;
    }

    public final org.hibernate.search.SearchException legacyJGroupsConfigurationDefined(final String indexName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000130: ")+ legacyJGroupsConfigurationDefined$str()), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String legacyJGroupsConfigurationDefined$str() {
        return legacyJGroupsConfigurationDefined;
    }

    public final org.hibernate.search.SearchException unsupportedTikaBridgeType() {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000151: ")+ unsupportedTikaBridgeType$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTikaBridgeType$str() {
        return unsupportedTikaBridgeType;
    }

    public final void ignoringBackendOptionForIndex(final String indexName, final String forcedBackend) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000104: ")+ ignoringBackendOptionForIndex$str()), indexName, forcedBackend);
    }

    protected String ignoringBackendOptionForIndex$str() {
        return ignoringBackendOptionForIndex;
    }

    public final org.hibernate.search.SearchException noFieldBridgeInterfaceImplementedByClassBridge(final String implName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000133: ")+ noFieldBridgeInterfaceImplementedByClassBridge$str()), implName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByClassBridge$str() {
        return noFieldBridgeInterfaceImplementedByClassBridge;
    }

    public final org.hibernate.search.errors.EmptyQueryException queryWithNoTermsAfterAnalysis(final String field, final String searchTerm) {
        org.hibernate.search.errors.EmptyQueryException result = new org.hibernate.search.errors.EmptyQueryException(String.format(((projectCode +"000146: ")+ queryWithNoTermsAfterAnalysis$str()), field, searchTerm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoTermsAfterAnalysis$str() {
        return queryWithNoTermsAfterAnalysis;
    }

    public final void jGroupsClosingChannelError(final Exception toLog) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (toLog), ((projectCode +"000014: ")+ jGroupsClosingChannelError$str()));
    }

    protected String jGroupsClosingChannelError$str() {
        return jGroupsClosingChannelError;
    }

    public final void closedBlackholeBackend() {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000002: ")+ closedBlackholeBackend$str()));
    }

    protected String closedBlackholeBackend$str() {
        return closedBlackholeBackend;
    }

    public final org.hibernate.search.SearchException unableToDetermineClassBridge(final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000149: ")+ unableToDetermineClassBridge$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineClassBridge$str() {
        return unableToDetermineClassBridge;
    }

    public final org.hibernate.search.SearchException cannotReadFieldForClass(final String fieldName, final String className) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000156: ")+ cannotReadFieldForClass$str()), fieldName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadFieldForClass$str() {
        return cannotReadFieldForClass;
    }

    public final void readersNotProperlyClosedInReaderProvider() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000054: ")+ readersNotProperlyClosedInReaderProvider$str()));
    }

    protected String readersNotProperlyClosedInReaderProvider$str() {
        return readersNotProperlyClosedInReaderProvider;
    }

    public final org.hibernate.search.SearchException unableToInstantiateSpatial(final String className, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000136: ")+ unableToInstantiateSpatial$str()), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateSpatial$str() {
        return unableToInstantiateSpatial;
    }

    public final void indexDirectoryNotFoundCreatingNewOne(final String absolutePath) {
        super.log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000041: ")+ indexDirectoryNotFoundCreatingNewOne$str()), absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return indexDirectoryNotFoundCreatingNewOne;
    }

    public final void unableToSynchronizeSource(final String indexName, final Exception e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000021: ")+ unableToSynchronizeSource$str()), indexName);
    }

    protected String unableToSynchronizeSource$str() {
        return unableToSynchronizeSource;
    }

    public final void errorExecutingRunnableInTransaction(final Throwable e) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e), ((projectCode +"000064: ")+ errorExecutingRunnableInTransaction$str()));
    }

    protected String errorExecutingRunnableInTransaction$str() {
        return errorExecutingRunnableInTransaction;
    }

    public final org.hibernate.search.SearchException unknownAttributeSerializedRepresentation(final String name) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000086: ")+ unknownAttributeSerializedRepresentation$str()), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAttributeSerializedRepresentation$str() {
        return unknownAttributeSerializedRepresentation;
    }

    public final void forceToUseDocumentExtraction() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000038: ")+ forceToUseDocumentExtraction$str()));
    }

    protected String forceToUseDocumentExtraction$str() {
        return forceToUseDocumentExtraction;
    }

    public final void cannotExtractValueForIdentifier(final Class beanClass) {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000046: ")+ cannotExtractValueForIdentifier$str()), beanClass);
    }

    protected String cannotExtractValueForIdentifier$str() {
        return cannotExtractValueForIdentifier;
    }

    public final org.hibernate.annotations.common.AssertionFailure unknownIterableBridgeForResolution(final String resolution) {
        org.hibernate.annotations.common.AssertionFailure result = new org.hibernate.annotations.common.AssertionFailure(String.format(((projectCode +"000143: ")+ unknownIterableBridgeForResolution$str()), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownIterableBridgeForResolution$str() {
        return unknownIterableBridgeForResolution;
    }

    public final void errorRollingBackTransaction(final String message, final Exception e1) {
        super.log.logf(FQCN, (Logger.Level.ERROR), (e1), ((projectCode +"000065: ")+ errorRollingBackTransaction$str()), message);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    public final void forceRemoveOnIndexOperationViaInterception(final Class entityClass, final org.hibernate.search.backend.spi.WorkType type) {
        super.log.logf(FQCN, (Logger.Level.TRACE), null, ((projectCode +"000126: ")+ forceRemoveOnIndexOperationViaInterception$str()), entityClass, type);
    }

    protected String forceRemoveOnIndexOperationViaInterception$str() {
        return forceRemoveOnIndexOperationViaInterception;
    }

    public final org.hibernate.search.SearchException jGroupsChannelCreationUsingXmlError(final String configuration, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000009: ")+ jGroupsChannelCreationUsingXmlError$str()), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationUsingXmlError$str() {
        return jGroupsChannelCreationUsingXmlError;
    }

    public final void checkSizeMustBePositive() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000053: ")+ checkSizeMustBePositive$str()));
    }

    protected String checkSizeMustBePositive$str() {
        return checkSizeMustBePositive;
    }

    public final org.hibernate.search.SearchException unableToGuessFieldBridge(final String className, final String fieldName) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000135: ")+ unableToGuessFieldBridge$str()), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGuessFieldBridge$str() {
        return unableToGuessFieldBridge;
    }

    public final org.hibernate.search.SearchException cannotInstantiateClassBridgeOfType(final String implName, final String className, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000134: ")+ cannotInstantiateClassBridgeOfType$str()), implName, className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateClassBridgeOfType$str() {
        return cannotInstantiateClassBridgeOfType;
    }

    public final void abstractClassesCannotInsertDocuments() {
        super.log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000044: ")+ abstractClassesCannotInsertDocuments$str()));
    }

    protected String abstractClassesCannotInsertDocuments$str() {
        return abstractClassesCannotInsertDocuments;
    }

    public final void similarityInstantiationException(final String similarityName, final String beanXClassName) {
        super.log.logf(FQCN, (Logger.Level.ERROR), null, ((projectCode +"000004: ")+ similarityInstantiationException$str()), similarityName, beanXClassName);
    }

    protected String similarityInstantiationException$str() {
        return similarityInstantiationException;
    }

    public final org.hibernate.search.SearchException jmsLookupException(final String jmsQueueName, final String jmsConnectionFactoryName, final String indexName, final Throwable e) {
        org.hibernate.search.SearchException result = new org.hibernate.search.SearchException(String.format(((projectCode +"000164: ")+ jmsLookupException$str()), jmsQueueName, jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsLookupException$str() {
        return jmsLookupException;
    }

}
