/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import junit.framework.Assert;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.DefaultIndexManagerFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1211")
public class IndexManagerFactoryCustomizationTest {
    @Test
    public void testDefaultImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        this.verifyIndexManagerTypeIs(DirectoryBasedIndexManager.class, cfg);
    }

    @Test
    public void testOverriddenDefaultImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setIndexManagerFactory((IndexManagerFactory)new DefaultIndexManagerFactory(){

            public IndexManager createDefaultIndexManager() {
                return new NRTIndexManager();
            }
        });
        this.verifyIndexManagerTypeIs(NRTIndexManager.class, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexManagerTypeIs(Class<? extends IndexManager> expectedIndexManagerClass, ManualConfiguration cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().indexName("documents").property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        cfg.addClass(Document.class);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        try {
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "documents"));
            sf.addClasses(new Class[]{Dvd.class});
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "dvds"));
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "documents"));
        }
        finally {
            sf.close();
        }
    }

    private Class<? extends IndexManager> extractDocumentIndexManagerClassName(SearchFactoryImplementor sf, String indexName) {
        IndexManager indexManager = sf.getAllIndexesManager().getIndexManager(indexName);
        Assert.assertNotNull((Object)indexManager);
        return indexManager.getClass();
    }

    @Indexed(index="dvds")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

