/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;

public class LeakingLuceneBackend
extends LuceneBackendQueueProcessor {
    private static volatile List<LuceneWork> lastProcessedQueue = new ArrayList<LuceneWork>();

    public void close() {
        lastProcessedQueue = new ArrayList<LuceneWork>();
        super.close();
    }

    public static List<LuceneWork> getLastProcessedQueue() {
        return lastProcessedQueue;
    }

    public static void reset() {
        lastProcessedQueue = new ArrayList<LuceneWork>();
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        super.applyWork(workList, monitor);
        lastProcessedQueue = workList;
    }
}

