/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Counter;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.collector.impl.FacetCollector;
import org.hibernate.search.query.collector.impl.FieldCacheCollector;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.engine.impl.IndexSearcherWithPayload;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.spatial.impl.DistanceCollector;
import org.hibernate.search.spatial.impl.Point;

public class QueryHits {
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    private final Query preparedQuery;
    private final IndexSearcherWithPayload searcher;
    private final Filter filter;
    private final Sort sort;
    private final Map<String, FacetingRequestImpl> facetRequests;
    private final TimeoutManagerImpl timeoutManager;
    private int totalHits;
    private TopDocs topDocs;
    private Map<String, List<Facet>> facetMap;
    private List<FacetCollector> facetCollectors;
    private DistanceCollector distanceCollector = null;
    private final boolean enableFieldCacheOnClassName;
    private Point spatialSearchCenter = null;
    private String spatialFieldName = null;
    private FieldCacheCollector classTypeCollector;
    private final FieldCacheCollectorFactory idFieldCollectorFactory;
    private FieldCacheCollector idFieldCollector;
    private final TimeoutExceptionFactory timeoutExceptionFactory;

    public QueryHits(IndexSearcherWithPayload searcher, Query preparedQuery, Filter filter, Sort sort, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, boolean enableFieldCacheOnTypes, FieldCacheCollectorFactory idFieldCollector, TimeoutExceptionFactory timeoutExceptionFactory, Point spatialSearchCenter, String spatialFieldName) throws IOException {
        this(searcher, preparedQuery, filter, sort, 100, timeoutManager, facetRequests, enableFieldCacheOnTypes, idFieldCollector, timeoutExceptionFactory, spatialSearchCenter, spatialFieldName);
    }

    public QueryHits(IndexSearcherWithPayload searcher, Query preparedQuery, Filter filter, Sort sort, Integer n, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, boolean enableFieldCacheOnTypes, FieldCacheCollectorFactory idFieldCollector, TimeoutExceptionFactory timeoutExceptionFactory, Point spatialSearchCenter, String spatialFieldName) throws IOException {
        this.timeoutManager = timeoutManager;
        this.preparedQuery = preparedQuery;
        this.searcher = searcher;
        this.filter = filter;
        this.sort = sort;
        this.facetRequests = facetRequests;
        this.enableFieldCacheOnClassName = enableFieldCacheOnTypes;
        this.idFieldCollectorFactory = idFieldCollector;
        this.timeoutExceptionFactory = timeoutExceptionFactory;
        this.spatialSearchCenter = spatialSearchCenter;
        this.spatialFieldName = spatialFieldName;
        this.updateTopDocs(n);
    }

    public Document doc(int index) throws IOException {
        return this.searcher.getSearcher().doc(this.docId(index));
    }

    public Document doc(int index, FieldSelector selector) throws IOException {
        return this.searcher.getSearcher().doc(this.docId(index), selector);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        if (this.timeoutManager.isTimedOut() && index >= this.topDocs.scoreDocs.length) {
            throw this.timeoutExceptionFactory.createTimeoutException("Timeout period exceeded. Cannot load document: " + index, this.preparedQuery);
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Double spatialDistance(int index) throws IOException {
        if (this.spatialSearchCenter == null) {
            return null;
        }
        return this.distanceCollector.getDistance(index);
    }

    public Explanation explain(int index) throws IOException {
        Explanation explanation = this.searcher.getSearcher().explain(this.preparedQuery, this.docId(index));
        this.timeoutManager.isTimedOut();
        return explanation;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    public Map<String, List<Facet>> getFacets() {
        if (this.facetRequests == null || this.facetRequests.size() == 0) {
            return Collections.emptyMap();
        }
        return this.facetMap;
    }

    private void updateTopDocs(int n) throws IOException {
        Collector hitCountCollector;
        Collector topDocCollector;
        int totalMaxDocs = this.searcher.getSearcher().maxDoc();
        int maxDocs = Math.min(n, totalMaxDocs);
        Weight weight = this.preparedQuery.weight((Searcher)this.searcher.getSearcher());
        Collector collector = null;
        if (maxDocs != 0) {
            topDocCollector = this.createTopDocCollector(maxDocs, weight);
            hitCountCollector = null;
            collector = topDocCollector;
            collector = this.optionallyEnableFieldCacheOnTypes(collector, totalMaxDocs, maxDocs);
            collector = this.optionallyEnableFieldCacheOnIds(collector, totalMaxDocs, maxDocs);
            collector = this.optionallyEnableFacetingCollectors(collector);
            collector = this.optionallyEnableDistanceCollector(collector, maxDocs);
        } else {
            topDocCollector = null;
            collector = hitCountCollector = new TotalHitCountCollector();
        }
        collector = this.decorateWithTimeOutCollector(collector);
        boolean timeoutNow = this.isImmediateTimeout();
        if (!timeoutNow) {
            try {
                this.searcher.getSearcher().search(weight, this.filter, collector);
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                this.timeoutManager.forceTimedOut();
            }
        }
        if (maxDocs != 0) {
            this.topDocs = topDocCollector.topDocs();
            this.totalHits = this.topDocs.totalHits;
            if (this.facetCollectors != null && !this.facetCollectors.isEmpty()) {
                this.facetMap = new HashMap<String, List<Facet>>();
                for (FacetCollector facetCollector : this.facetCollectors) {
                    this.facetMap.put(facetCollector.getFacetName(), facetCollector.getFacetList());
                }
            }
        } else {
            this.topDocs = null;
            this.totalHits = hitCountCollector.getTotalHits();
        }
        this.timeoutManager.isTimedOut();
    }

    private Collector optionallyEnableFacetingCollectors(Collector collector) {
        if (this.facetRequests == null || this.facetRequests.isEmpty()) {
            return collector;
        }
        this.facetCollectors = new ArrayList<FacetCollector>();
        Collector nextInChain = collector;
        for (FacetingRequestImpl entry : this.facetRequests.values()) {
            FacetCollector facetCollector = new FacetCollector(nextInChain, entry);
            nextInChain = facetCollector;
            this.facetCollectors.add(facetCollector);
        }
        return this.facetCollectors.get(this.facetCollectors.size() - 1);
    }

    private Collector optionallyEnableDistanceCollector(Collector collector, int maxDocs) {
        if (this.spatialFieldName == null || this.spatialFieldName.isEmpty() || this.spatialSearchCenter == null) {
            return collector;
        }
        this.distanceCollector = new DistanceCollector(collector, this.spatialSearchCenter, maxDocs, this.spatialFieldName);
        return this.distanceCollector;
    }

    private boolean isImmediateTimeout() {
        boolean timeoutAt0 = false;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT) {
            Long timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds();
            if (timeoutLeft != null) {
                if (timeoutLeft == 0L && this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && this.timeoutManager.isTimedOut()) {
                    this.timeoutManager.forceTimedOut();
                    timeoutAt0 = true;
                }
            } else if (this.timeoutManager.isTimedOut()) {
                this.timeoutManager.forceTimedOut();
            }
        }
        return timeoutAt0;
    }

    private Collector decorateWithTimeOutCollector(Collector collector) {
        Long timeoutLeft;
        Collector maybeTimeLimitingCollector = collector;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && (timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds()) != null) {
            Counter counter = this.timeoutManager.getLuceneTimeoutCounter();
            maybeTimeLimitingCollector = new TimeLimitingCollector(collector, counter, timeoutLeft.longValue());
        }
        return maybeTimeLimitingCollector;
    }

    private TopDocsCollector<?> createTopDocCollector(int maxDocs, Weight weight) throws IOException {
        TopScoreDocCollector topCollector;
        if (this.sort == null) {
            topCollector = TopScoreDocCollector.create((int)maxDocs, (!weight.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        } else {
            boolean fillFields = true;
            topCollector = TopFieldCollector.create((Sort)this.sort, (int)maxDocs, (boolean)fillFields, (boolean)this.searcher.isFieldSortDoTrackScores(), (boolean)this.searcher.isFieldSortDoMaxScore(), (!weight.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        }
        return topCollector;
    }

    private Collector optionallyEnableFieldCacheOnIds(Collector collector, int totalMaxDocs, int maxDocs) {
        if (this.idFieldCollectorFactory != null) {
            this.idFieldCollector = this.idFieldCollectorFactory.createFieldCollector(collector, totalMaxDocs, maxDocs);
            return this.idFieldCollector;
        }
        return collector;
    }

    private Collector optionallyEnableFieldCacheOnTypes(Collector collector, int totalMaxDocs, int expectedMatchesCount) {
        if (this.enableFieldCacheOnClassName) {
            this.classTypeCollector = FieldCacheCollectorFactory.CLASS_TYPE_FIELD_CACHE_COLLECTOR_FACTORY.createFieldCollector(collector, totalMaxDocs, expectedMatchesCount);
            return this.classTypeCollector;
        }
        return collector;
    }

    public FieldCacheCollector getClassTypeCollector() {
        return this.classTypeCollector;
    }

    public FieldCacheCollector getIdsCollector() {
        return this.idFieldCollector;
    }
}

