/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.spatial.SpatialFieldBridge;

public class SpatialFieldBridgeByRange
extends SpatialFieldBridge {
    public SpatialFieldBridgeByRange() {
        this.fieldMode = false;
    }

    public SpatialFieldBridgeByRange(String latitudeField, String longitudeField) {
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
        this.fieldMode = true;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                luceneOptions.addNumericFieldToDocument(name + "_HSSI_Latitude", latitude, document);
                luceneOptions.addNumericFieldToDocument(name + "_HSSI_Longitude", longitude, document);
            }
        }
    }
}

