/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.spatial.impl.GridHelper;
import org.hibernate.search.spatial.impl.Point;

public class DistanceCollector
extends Collector {
    private Collector delegate;
    private boolean acceptsDocsOutOfOrder;
    private Point center;
    private String latitudeField;
    private String longitudeField;
    private int docBase = 0;
    private double[] distances;
    private double[] latitudeValues;
    private double[] longitudeValues;

    public DistanceCollector(Collector delegate, Point center, int hitsCount, String fieldname) {
        this.delegate = delegate;
        this.acceptsDocsOutOfOrder = delegate.acceptsDocsOutOfOrder();
        this.center = center;
        this.distances = new double[hitsCount];
        this.latitudeValues = new double[hitsCount];
        this.longitudeValues = new double[hitsCount];
        this.latitudeField = GridHelper.formatLatitude(fieldname);
        this.longitudeField = GridHelper.formatLongitude(fieldname);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        int absolute = this.docBase + doc;
        this.distances[absolute] = this.center.getDistanceTo(this.latitudeValues[absolute], this.longitudeValues[absolute]);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.delegate.setNextReader(reader, docBase);
        double[] unbasedLatitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.latitudeField);
        double[] unbasedLongitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.longitudeField);
        this.docBase = docBase;
        for (int i = 0; i < unbasedLatitudeValues.length; ++i) {
            this.latitudeValues[this.docBase + i] = unbasedLatitudeValues[i];
            this.longitudeValues[this.docBase + i] = unbasedLongitudeValues[i];
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.acceptsDocsOutOfOrder;
    }

    public double getDistance(int index) {
        return this.distances[index];
    }
}

