/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.hibernate.search.spatial.impl.GridHelper;
import org.hibernate.search.spatial.impl.Point;

public final class DistanceComparator
extends FieldComparator<Double> {
    private final Point center;
    private final String latitudeField;
    private final String longitudeField;
    private final double[] distances;
    private final double[] latitudeValues;
    private final double[] longitudeValues;
    private Double bottomDistance;
    private int docBase = 0;

    public DistanceComparator(Point center, int hitsCount, String fieldname) {
        this.center = center;
        this.distances = new double[hitsCount];
        this.latitudeValues = new double[hitsCount];
        this.longitudeValues = new double[hitsCount];
        this.latitudeField = GridHelper.formatLatitude(fieldname);
        this.longitudeField = GridHelper.formatLongitude(fieldname);
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.distances[slot1], this.distances[slot2]);
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.center.getDistanceTo(this.latitudeValues[slot], this.longitudeValues[slot]);
    }

    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottomDistance, this.distances[doc]);
    }

    public void copy(int slot, int doc) throws IOException {
        this.distances[slot] = this.center.getDistanceTo(this.latitudeValues[doc], this.longitudeValues[doc]);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        double[] unbasedLatitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.latitudeField);
        double[] unbasedLongitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.longitudeField);
        this.docBase = docBase;
        for (int i = 0; i < unbasedLatitudeValues.length; ++i) {
            this.latitudeValues[this.docBase + i] = unbasedLatitudeValues[i];
            this.longitudeValues[this.docBase + i] = unbasedLongitudeValues[i];
        }
    }

    public Double value(int slot) {
        return this.center.getDistanceTo(this.latitudeValues[slot], this.longitudeValues[slot]);
    }
}

