/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.spatial.impl.GridHelper;
import org.hibernate.search.spatial.impl.Point;

public final class DistanceFilter
extends Filter {
    private Filter previousFilter;
    private Point center;
    private double radius;
    private String coordinatesField;
    private String latitudeField;
    private String longitudeField;

    public DistanceFilter(Filter previousFilter, Point center, double radius, String coordinatesField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        this.center = center;
        this.radius = radius;
        this.coordinatesField = coordinatesField;
    }

    public DistanceFilter(Filter previousFilter, Point center, double radius, String latitudeField, String longitudeField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        this.center = center;
        this.radius = radius;
        this.coordinatesField = null;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final double[] latitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.getLatitudeField());
        final double[] longitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.getLongitudeField());
        DocIdSet docs = this.previousFilter.getDocIdSet(reader);
        if (docs == null || docs.iterator() == null) {
            return null;
        }
        return new FilteredDocIdSet(docs){

            protected boolean match(int documentIndex) {
                return DistanceFilter.this.center.getDistanceTo(latitudeValues[documentIndex], longitudeValues[documentIndex]) <= DistanceFilter.this.radius;
            }
        };
    }

    private String getLatitudeField() {
        if (this.latitudeField != null) {
            return this.latitudeField;
        }
        return GridHelper.formatLatitude(this.coordinatesField);
    }

    private String getLongitudeField() {
        if (this.longitudeField != null) {
            return this.longitudeField;
        }
        return GridHelper.formatLongitude(this.coordinatesField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistanceFilter");
        sb.append("{previousFilter=").append(this.previousFilter);
        sb.append(", center=").append(this.center);
        sb.append(", radius=").append(this.radius);
        if (this.coordinatesField != null) {
            sb.append(", coordinatesField='").append(this.coordinatesField).append('\'');
        } else {
            sb.append(", latitudeField=").append(this.latitudeField);
            sb.append(", longitudeField=").append(this.longitudeField).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

