/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;

public abstract class GridHelper {
    private static final double LOG2 = Math.log(2.0);

    private GridHelper() {
    }

    public static int getCellIndex(double coordinate, double range, int gridLevel) {
        return (int)Math.floor(Math.pow(2.0, gridLevel) * coordinate / range);
    }

    public static String getGridCellId(Point point, int gridLevel) {
        double[] indexablesCoordinates = GridHelper.projectToIndexSpace(point);
        int longitudeCellIndex = GridHelper.getCellIndex(indexablesCoordinates[0], Math.PI * 2, gridLevel);
        int latitudeCellIndex = GridHelper.getCellIndex(indexablesCoordinates[1], Math.PI, gridLevel);
        return GridHelper.formatGridCellId(longitudeCellIndex, latitudeCellIndex);
    }

    public static List<String> getGridCellsIds(Point lowerLeft, Point upperRight, int gridLevel) {
        double[] projectedLowerLeft = GridHelper.projectToIndexSpace(lowerLeft);
        int lowerLeftXIndex = GridHelper.getCellIndex(projectedLowerLeft[0], Math.PI * 2, gridLevel);
        int lowerLeftYIndex = GridHelper.getCellIndex(projectedLowerLeft[1], Math.PI, gridLevel);
        double[] projectedUpperRight = GridHelper.projectToIndexSpace(upperRight);
        int upperRightXIndex = GridHelper.getCellIndex(projectedUpperRight[0], Math.PI * 2, gridLevel);
        int upperRightYIndex = GridHelper.getCellIndex(projectedUpperRight[1], Math.PI, gridLevel);
        double[] projectedLowerRight = GridHelper.projectToIndexSpace(Point.fromDegrees(lowerLeft.getLatitude(), upperRight.getLongitude()));
        int lowerRightXIndex = GridHelper.getCellIndex(projectedLowerRight[0], Math.PI * 2, gridLevel);
        int lowerRightYIndex = GridHelper.getCellIndex(projectedLowerRight[1], Math.PI, gridLevel);
        double[] projectedUpperLeft = GridHelper.projectToIndexSpace(Point.fromDegrees(upperRight.getLatitude(), lowerLeft.getLongitude()));
        int upperLeftXIndex = GridHelper.getCellIndex(projectedUpperLeft[0], Math.PI * 2, gridLevel);
        int upperLeftYIndex = GridHelper.getCellIndex(projectedUpperLeft[1], Math.PI, gridLevel);
        int startX = Math.min(Math.min(Math.min(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int endX = Math.max(Math.max(Math.max(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int startY = Math.min(Math.min(Math.min(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        int endY = Math.max(Math.max(Math.max(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        ArrayList<String> gridCellsIds = new ArrayList<String>((endX + 1 - startX) * (endY + 1 - startY));
        for (int xIndex = startX; xIndex <= endX; ++xIndex) {
            for (int yIndex = startY; yIndex <= endY; ++yIndex) {
                gridCellsIds.add(GridHelper.formatGridCellId(xIndex, yIndex));
            }
        }
        return gridCellsIds;
    }

    public static List<String> getGridCellsIds(Point center, double radius, int gridLevel) {
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        double lowerLeftLatitude = boundingBox.getLowerLeft().getLatitude();
        double lowerLeftLongitude = boundingBox.getLowerLeft().getLongitude();
        double upperRightLatitude = boundingBox.getUpperRight().getLatitude();
        double upperRightLongitude = boundingBox.getUpperRight().getLongitude();
        if (upperRightLongitude < lowerLeftLongitude) {
            List<String> gridCellsIds = GridHelper.getGridCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, 180.0), gridLevel);
            gridCellsIds.addAll(GridHelper.getGridCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, -180.0), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), gridLevel));
            return gridCellsIds;
        }
        return GridHelper.getGridCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), gridLevel);
    }

    public static int findBestGridLevelForSearchRange(double searchRange) {
        double iterations = 40075.017 / (2.0 * searchRange);
        return (int)Math.max(0.0, Math.ceil(Math.log(iterations) / LOG2));
    }

    public static double[] projectToIndexSpace(Point point) {
        double[] projectedCoordinates = new double[]{point.getLongitudeRad() * Math.cos(point.getLatitudeRad()), point.getLatitudeRad()};
        return projectedCoordinates;
    }

    public static String formatFieldName(int gridLevel, String fieldName) {
        return fieldName + "_HSSI_" + gridLevel;
    }

    public static String formatLatitude(String fieldName) {
        return fieldName + "_HSSI_Latitude";
    }

    public static String formatLongitude(String fieldName) {
        return fieldName + "_HSSI_Longitude";
    }

    public static String formatGridCellId(int xIndex, int yIndex) {
        return xIndex + "|" + yIndex;
    }
}

