/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.spatial.impl.DistanceFilter;
import org.hibernate.search.spatial.impl.GridFilter;
import org.hibernate.search.spatial.impl.GridHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;

public abstract class SpatialQueryBuilderFromPoint {
    public static Filter buildGridFilter(Point center, double radius, String fieldName) {
        int bestGridLevel = GridHelper.findBestGridLevelForSearchRange(2.0 * radius);
        if (bestGridLevel > 16) {
            bestGridLevel = 16;
        }
        List<String> gridCellsIds = GridHelper.getGridCellsIds(center, radius, bestGridLevel);
        return new GridFilter(gridCellsIds, GridHelper.formatFieldName(bestGridLevel, fieldName));
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Point center, double radius, String coordinatesField) {
        return new DistanceFilter(previousFilter, center, radius, coordinatesField);
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Point center, double radius, String latitudeField, String longitudeField) {
        return new DistanceFilter(previousFilter, center, radius, latitudeField, longitudeField);
    }

    public static Query buildGridQuery(Point center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromPoint.buildGridFilter(center, radius, fieldName));
    }

    public static Query buildDistanceQuery(Point center, double radius, String fieldName) {
        QueryWrapperFilter allFilter = new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromPoint.buildDistanceFilter((Filter)allFilter, center, radius, fieldName));
    }

    public static Query buildSpatialQueryByGrid(Point center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromPoint.buildDistanceFilter(SpatialQueryBuilderFromPoint.buildGridFilter(center, radius, fieldName), center, radius, fieldName));
    }

    public static Query buildSpatialQueryByRange(Point center, double radius, String fieldName) {
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        String latitudeFieldName = fieldName + "_HSSI_Latitude";
        String longitudeFieldName = fieldName + "_HSSI_Longitude";
        NumericRangeQuery latQuery = NumericRangeQuery.newDoubleRange((String)latitudeFieldName, (Double)boundingBox.getLowerLeft().getLatitude(), (Double)boundingBox.getUpperRight().getLatitude(), (boolean)true, (boolean)true);
        BooleanQuery longQuery = null;
        if (boundingBox.getLowerLeft().getLongitude() <= boundingBox.getUpperRight().getLongitude()) {
            longQuery = NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true);
        } else {
            longQuery = new BooleanQuery();
            longQuery.add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)180.0, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
            longQuery.add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)-180.0, (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery boxQuery = new BooleanQuery();
        boxQuery.add((Query)latQuery, BooleanClause.Occur.MUST);
        boxQuery.add((Query)longQuery, BooleanClause.Occur.MUST);
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromPoint.buildDistanceFilter((Filter)new QueryWrapperFilter((Query)boxQuery), center, radius, latitudeFieldName, longitudeFieldName));
    }
}

