/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.net.URL;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TestConstants {
    public static final Analyzer standardAnalyzer = new StandardAnalyzer(TestConstants.getTargetLuceneVersion());
    public static final Analyzer stopAnalyzer = new StopAnalyzer(TestConstants.getTargetLuceneVersion());
    public static final Analyzer simpleAnalyzer = new SimpleAnalyzer(TestConstants.getTargetLuceneVersion());
    public static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private static final Log log = LoggerFactory.make();

    public static Version getTargetLuceneVersion() {
        return Version.LUCENE_CURRENT;
    }

    public static File getTargetDir(Class<?> testClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentTestClass = testClass.getName();
        int hopsToCompileDirectory = currentTestClass.split("\\.").length;
        int hopsToTargetDirectory = hopsToCompileDirectory + 1;
        URL classURL = contextClassLoader.getResource(currentTestClass.replace('.', '/') + ".class");
        File targetDir = new File(classURL.getFile());
        for (int i = 0; i < hopsToTargetDirectory; ++i) {
            targetDir = targetDir.getParentFile();
        }
        return targetDir;
    }

    public static String getIndexDirectory(Class<?> testClass) {
        File targetDir = TestConstants.getTargetDir(testClass);
        String indexDirPath = targetDir.getAbsolutePath() + File.separator + "indextemp";
        log.debugf("Using %s as index directory.", (Object)indexDirPath);
        return indexDirPath;
    }
}

