/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.AppliedOnTypeAwareBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.junit.Assert;
import org.junit.Test;

public class AppliedOnTypeAwareBridgeTest {
    @Test
    public void testTypeIsSetForField() {
        SearchFactoryImplementor searchFactory = this.createSearchFactory(Foo.class);
        Foo foo = new Foo(0L);
        Work work = new Work((Object)foo, (Serializable)Long.valueOf(foo.getId()), WorkType.ADD, false);
        ManualTransactionContext tc = new ManualTransactionContext();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Test
    public void testTypeIsSetForGetter() {
        SearchFactoryImplementor searchFactory = this.createSearchFactory(Bar.class);
        Bar bar = new Bar(0L);
        Work work = new Work((Object)bar, (Serializable)Long.valueOf(bar.getId()), WorkType.ADD, false);
        ManualTransactionContext tc = new ManualTransactionContext();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Test
    public void testTypeIsSetForClass() {
        SearchFactoryImplementor searchFactory = this.createSearchFactory(Snafu.class);
        Snafu snafu = new Snafu(0L);
        Work work = new Work((Object)snafu, (Serializable)Long.valueOf(snafu.getId()), WorkType.ADD, false);
        ManualTransactionContext tc = new ManualTransactionContext();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private SearchFactoryImplementor createSearchFactory(Class<?> clazz) {
        ManualConfiguration configuration = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").addClass(clazz);
        return new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
    }

    public static class TypeAssertingFieldBridge
    implements org.hibernate.search.bridge.FieldBridge,
    AppliedOnTypeAwareBridge,
    ParameterizedBridge {
        private Class<?> expectedType;
        private Class<?> actualType;

        public void setAppliedOnType(Class<?> returnType) {
            this.actualType = returnType;
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Assert.assertTrue((String)"Type not set prior to calling #set of field bridge", (this.actualType != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Unexpected type", this.expectedType, this.actualType);
        }

        public void setParameterValues(Map<String, String> parameters) {
            String expectedTypeName = parameters.get("type");
            this.expectedType = ClassLoaderHelper.classForName((String)expectedTypeName, (ClassLoader)this.getClass().getClassLoader(), (String)"Unable to load type");
        }
    }

    @Indexed
    @ClassBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="org.hibernate.search.test.bridge.AppliedOnTypeAwareBridgeTest$Snafu")})
    public static class Snafu {
        @DocumentId
        private Long id;

        public Snafu(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }

    @Indexed
    public static class Bar {
        @DocumentId
        private Long id;
        private Object test;

        public Bar(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        @Field(bridge=@FieldBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="java.lang.Object")}))
        public Object getTest() {
            return this.test;
        }
    }

    @Indexed
    public static class Foo {
        @DocumentId
        private Long id;
        @Field(bridge=@FieldBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="java.lang.Integer")}))
        private Integer test;

        public Foo(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }
}

