/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import junit.framework.Assert;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.util.impl.FileHelper;
import org.junit.Test;

public class ResourceLoadingTest {
    @Test
    public void testOpenKnownResource() throws Exception {
        String resource = "org/hibernate/search/remote/codex/avro/v1_0/Message.avro";
        String resourceContent = FileHelper.readResourceAsString((String)resource, (ClassLoader)AvroSerializationProvider.class.getClassLoader());
        Assert.assertNotNull((Object)resourceContent);
        Assert.assertFalse((boolean)resourceContent.isEmpty());
    }

    @Test
    public void testUnKnownResource() throws Exception {
        String resource = "foo";
        try {
            FileHelper.readResourceAsString((String)resource, (ClassLoader)AvroSerializationProvider.class.getClassLoader());
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong error message", (String)"HSEARCH000114: Could not load resource: 'foo'", (String)e.getMessage());
        }
    }
}

