/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.metadata.IndexDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.test.metadata.Foo;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-436")
public class IndexDescriptorTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        ConfigContext configContext = new ConfigContext((SearchConfiguration)new ManualConfiguration());
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testIndexInformation() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        Set indexDescriptors = typeDescriptor.getIndexDescriptors();
        Assert.assertEquals((String)"Wrong index name", (Object)DescriptorTestHelper.TEST_INDEX_NAMES.get(0), (Object)((IndexDescriptor)indexDescriptors.iterator().next()).getName());
    }

    @Test
    public void testSharedIndexInformation() {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(Foo.class);
        IndexedTypeDescriptorImpl typeDescriptor = new IndexedTypeDescriptorImpl(typeMetadata, DescriptorTestHelper.getDummyShardedIndexManager());
        Assert.assertTrue((boolean)typeDescriptor.isSharded());
        Set indexDescriptors = typeDescriptor.getIndexDescriptors();
        Assert.assertTrue((indexDescriptors.size() == 3 ? 1 : 0) != 0);
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            String shardName = indexDescriptor.getName();
            Assert.assertTrue((String)("Missing shard name: " + shardName), (boolean)DescriptorTestHelper.TEST_INDEX_NAMES.contains(indexDescriptor.getName()));
        }
    }
}

