/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Map;
import junit.framework.Assert;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.impl.NotSharedReaderProvider;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.util.impl.ReflectionHelper;

public class FieldSelectorLeakingReaderProvider
extends NotSharedReaderProvider
implements ReaderProvider {
    private static volatile FieldSelector fieldSelector;

    public static void resetFieldSelector() {
        fieldSelector = null;
    }

    public static void assertFieldSelectorEnabled(String ... expectedFieldNames) {
        if (expectedFieldNames == null || expectedFieldNames.length == 0) {
            Assert.assertNull((Object)fieldSelector);
        } else {
            Map fieldSelections;
            Assert.assertNotNull((Object)fieldSelector);
            MapFieldSelector selector = (MapFieldSelector)fieldSelector;
            try {
                Field field = MapFieldSelector.class.getDeclaredField("fieldSelections");
                ReflectionHelper.setAccessible((AccessibleObject)field);
                fieldSelections = (Map)field.get(selector);
            }
            catch (NoSuchFieldException e) {
                throw new SearchException("Incompatible version of Lucene: MapFieldSelector.fieldSelections not available", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new SearchException("Incompatible version of Lucene: MapFieldSelector.fieldSelections not available", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Incompatible version of Lucene: MapFieldSelector.fieldSelections not available", (Throwable)e);
            }
            Assert.assertNotNull((Object)fieldSelections);
            Assert.assertEquals((int)expectedFieldNames.length, (int)fieldSelections.size());
            for (String field : expectedFieldNames) {
                Assert.assertTrue((String)("did not contain field: " + field), (boolean)fieldSelections.containsKey(field));
                Assert.assertTrue((FieldSelectorResult.LOAD.equals(fieldSelections.get(field)) || FieldSelectorResult.LOAD_AND_BREAK.equals(fieldSelections.get(field)) ? 1 : 0) != 0);
            }
        }
    }

    public static void assertFieldSelectorDisabled() {
        Assert.assertNull((Object)fieldSelector);
    }

    public IndexReader openIndexReader() {
        IndexReader indexReader = super.openIndexReader();
        LeakingIndexReader leakingReader = new LeakingIndexReader(indexReader);
        return leakingReader;
    }

    private static class LeakingIndexReader
    extends IndexReader {
        private final IndexReader delegate;

        LeakingIndexReader(IndexReader wrapped) {
            this.delegate = wrapped;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Object clone() {
            return this.delegate.clone();
        }

        public IndexReader clone(boolean openReadOnly) throws IOException {
            return this.delegate.clone(openReadOnly);
        }

        public Directory directory() {
            return this.delegate.directory();
        }

        public long getVersion() {
            return this.delegate.getVersion();
        }

        public Map<String, String> getCommitUserData() {
            return this.delegate.getCommitUserData();
        }

        public boolean isCurrent() throws IOException {
            return this.delegate.isCurrent();
        }

        public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
            return this.delegate.getTermFreqVectors(docNumber);
        }

        public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
            return this.delegate.getTermFreqVector(docNumber, field);
        }

        public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
            this.delegate.getTermFreqVector(docNumber, field, mapper);
        }

        public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
            this.delegate.getTermFreqVector(docNumber, mapper);
        }

        public int numDocs() {
            return this.delegate.numDocs();
        }

        public int maxDoc() {
            return this.delegate.maxDoc();
        }

        public Document document(int n, FieldSelector fieldSelector) throws IOException {
            fieldSelector = fieldSelector;
            return this.delegate.document(n, fieldSelector);
        }

        public boolean isDeleted(int n) {
            return this.delegate.isDeleted(n);
        }

        public boolean hasDeletions() {
            return this.delegate.hasDeletions();
        }

        public boolean hasNorms(String field) throws IOException {
            return this.delegate.hasNorms(field);
        }

        public byte[] norms(String field) throws IOException {
            return this.delegate.norms(field);
        }

        public void norms(String field, byte[] bytes, int offset) throws IOException {
            this.delegate.norms(field, bytes, offset);
        }

        public TermEnum terms() throws IOException {
            return this.delegate.terms();
        }

        public TermEnum terms(Term t) throws IOException {
            return this.delegate.terms(t);
        }

        public int docFreq(Term t) throws IOException {
            return this.delegate.docFreq(t);
        }

        public TermDocs termDocs(Term term) throws IOException {
            return this.delegate.termDocs(term);
        }

        public TermDocs termDocs() throws IOException {
            return this.delegate.termDocs();
        }

        public TermPositions termPositions() throws IOException {
            return this.delegate.termPositions();
        }

        public IndexCommit getIndexCommit() throws IOException {
            return this.delegate.getIndexCommit();
        }

        public IndexReader[] getSequentialSubReaders() {
            return this.delegate.getSequentialSubReaders();
        }

        public Object getCoreCacheKey() {
            return this.delegate.getCoreCacheKey();
        }

        public Object getDeletesCacheKey() {
            return this.delegate.getDeletesCacheKey();
        }

        public long getUniqueTermCount() throws IOException {
            return this.delegate.getUniqueTermCount();
        }

        public int getTermInfosIndexDivisor() {
            return this.delegate.getTermInfosIndexDivisor();
        }

        protected void doSetNorm(int doc, String field, byte value) throws IOException {
            throw new UnsupportedOperationException("delegate method is not visible - hope we don't need it");
        }

        protected void doDelete(int docNum) throws IOException {
            throw new UnsupportedOperationException("delegate method is not visible - hope we don't need it");
        }

        protected void doUndeleteAll() throws IOException {
            throw new UnsupportedOperationException("delegate method is not visible - hope we don't need it");
        }

        protected void doCommit(Map<String, String> commitUserData) throws IOException {
        }

        protected void doClose() throws IOException {
        }

        public FieldInfos getFieldInfos() {
            return this.delegate.getFieldInfos();
        }
    }
}

