/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backends.jgroups;

import java.util.Arrays;
import junit.framework.Assert;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.impl.jgroups.MessageSerializationHelper;
import org.junit.Test;

public class SerializationHelperTest {
    @Test
    public void testIntEncoding() {
        for (int i = 0; i < 256; ++i) {
            byte byte1 = MessageSerializationHelper.fromIntToByte((int)i);
            int int1 = MessageSerializationHelper.fromByteToInt((byte)byte1);
            Assert.assertEquals((int)i, (int)int1);
        }
    }

    @Test(expected=SearchException.class)
    public void testIntTooLargeEncoding() {
        MessageSerializationHelper.fromIntToByte((int)256);
    }

    @Test
    public void exampleEncoding() {
        byte[] someRandom = "Some random string to test payload".getBytes();
        String indexName = "this is my favourite index";
        byte[] buffer = MessageSerializationHelper.prependString((String)indexName, (byte[])someRandom);
        Assert.assertEquals((String)indexName, (String)MessageSerializationHelper.extractIndexName((int)0, (byte[])buffer));
        Assert.assertTrue((boolean)Arrays.equals(someRandom, MessageSerializationHelper.extractSerializedQueue((int)0, (int)buffer.length, (byte[])buffer)));
    }

    @Test
    public void partialBufferEncoding() {
        byte[] someRandom = "Some random string to test payload".getBytes();
        String indexName = "this is my favourite index";
        byte[] buffer = MessageSerializationHelper.prependString((String)indexName, (byte[])someRandom);
        byte[] mixed = new byte[buffer.length + 7];
        System.arraycopy(buffer, 0, mixed, 2, buffer.length);
        Assert.assertEquals((String)indexName, (String)MessageSerializationHelper.extractIndexName((int)0, (byte[])buffer));
        Assert.assertTrue((boolean)Arrays.equals(someRandom, MessageSerializationHelper.extractSerializedQueue((int)0, (int)buffer.length, (byte[])buffer)));
    }
}

